/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.resiliencehub;

import javax.annotation.Generated;

import com.amazonaws.services.resiliencehub.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSResilienceHub}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSResilienceHub implements AWSResilienceHub {

    protected AbstractAWSResilienceHub() {
    }

    @Override
    public AddDraftAppVersionResourceMappingsResult addDraftAppVersionResourceMappings(AddDraftAppVersionResourceMappingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateRecommendationStatusResult batchUpdateRecommendationStatus(BatchUpdateRecommendationStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppResult createApp(CreateAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppVersionAppComponentResult createAppVersionAppComponent(CreateAppVersionAppComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppVersionResourceResult createAppVersionResource(CreateAppVersionResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRecommendationTemplateResult createRecommendationTemplate(CreateRecommendationTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResiliencyPolicyResult createResiliencyPolicy(CreateResiliencyPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppResult deleteApp(DeleteAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppAssessmentResult deleteAppAssessment(DeleteAppAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInputSourceResult deleteAppInputSource(DeleteAppInputSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppVersionAppComponentResult deleteAppVersionAppComponent(DeleteAppVersionAppComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppVersionResourceResult deleteAppVersionResource(DeleteAppVersionResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRecommendationTemplateResult deleteRecommendationTemplate(DeleteRecommendationTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResiliencyPolicyResult deleteResiliencyPolicy(DeleteResiliencyPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppResult describeApp(DescribeAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppAssessmentResult describeAppAssessment(DescribeAppAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppVersionResult describeAppVersion(DescribeAppVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppVersionAppComponentResult describeAppVersionAppComponent(DescribeAppVersionAppComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppVersionResourceResult describeAppVersionResource(DescribeAppVersionResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppVersionResourcesResolutionStatusResult describeAppVersionResourcesResolutionStatus(
            DescribeAppVersionResourcesResolutionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppVersionTemplateResult describeAppVersionTemplate(DescribeAppVersionTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDraftAppVersionResourcesImportStatusResult describeDraftAppVersionResourcesImportStatus(
            DescribeDraftAppVersionResourcesImportStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeResiliencyPolicyResult describeResiliencyPolicy(DescribeResiliencyPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportResourcesToDraftAppVersionResult importResourcesToDraftAppVersion(ImportResourcesToDraftAppVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAlarmRecommendationsResult listAlarmRecommendations(ListAlarmRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppAssessmentComplianceDriftsResult listAppAssessmentComplianceDrifts(ListAppAssessmentComplianceDriftsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppAssessmentsResult listAppAssessments(ListAppAssessmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppComponentCompliancesResult listAppComponentCompliances(ListAppComponentCompliancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppComponentRecommendationsResult listAppComponentRecommendations(ListAppComponentRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInputSourcesResult listAppInputSources(ListAppInputSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppVersionAppComponentsResult listAppVersionAppComponents(ListAppVersionAppComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppVersionResourceMappingsResult listAppVersionResourceMappings(ListAppVersionResourceMappingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppVersionResourcesResult listAppVersionResources(ListAppVersionResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppVersionsResult listAppVersions(ListAppVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppsResult listApps(ListAppsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecommendationTemplatesResult listRecommendationTemplates(ListRecommendationTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResiliencyPoliciesResult listResiliencyPolicies(ListResiliencyPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSopRecommendationsResult listSopRecommendations(ListSopRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSuggestedResiliencyPoliciesResult listSuggestedResiliencyPolicies(ListSuggestedResiliencyPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTestRecommendationsResult listTestRecommendations(ListTestRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUnsupportedAppVersionResourcesResult listUnsupportedAppVersionResources(ListUnsupportedAppVersionResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PublishAppVersionResult publishAppVersion(PublishAppVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutDraftAppVersionTemplateResult putDraftAppVersionTemplate(PutDraftAppVersionTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveDraftAppVersionResourceMappingsResult removeDraftAppVersionResourceMappings(RemoveDraftAppVersionResourceMappingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResolveAppVersionResourcesResult resolveAppVersionResources(ResolveAppVersionResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAppAssessmentResult startAppAssessment(StartAppAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppResult updateApp(UpdateAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppVersionResult updateAppVersion(UpdateAppVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppVersionAppComponentResult updateAppVersionAppComponent(UpdateAppVersionAppComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppVersionResourceResult updateAppVersionResource(UpdateAppVersionResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResiliencyPolicyResult updateResiliencyPolicy(UpdateResiliencyPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
