/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.robomaker.model.WorldSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListWorldsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<WorldSummary> worldSummaries;
    private String nextToken;

    public List<WorldSummary> getWorldSummaries() {
        return this.worldSummaries;
    }

    public void setWorldSummaries(Collection<WorldSummary> worldSummaries) {
        if (worldSummaries == null) {
            this.worldSummaries = null;
            return;
        }
        this.worldSummaries = new ArrayList<WorldSummary>(worldSummaries);
    }

    public ListWorldsResult withWorldSummaries(WorldSummary ... worldSummaries) {
        if (this.worldSummaries == null) {
            this.setWorldSummaries(new ArrayList<WorldSummary>(worldSummaries.length));
        }
        for (WorldSummary ele : worldSummaries) {
            this.worldSummaries.add(ele);
        }
        return this;
    }

    public ListWorldsResult withWorldSummaries(Collection<WorldSummary> worldSummaries) {
        this.setWorldSummaries(worldSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListWorldsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorldSummaries() != null) {
            sb.append("WorldSummaries: ").append(this.getWorldSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorldsResult)) {
            return false;
        }
        ListWorldsResult other = (ListWorldsResult)obj;
        if (other.getWorldSummaries() == null ^ this.getWorldSummaries() == null) {
            return false;
        }
        if (other.getWorldSummaries() != null && !other.getWorldSummaries().equals(this.getWorldSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorldSummaries() == null ? 0 : this.getWorldSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListWorldsResult clone() {
        try {
            return (ListWorldsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

