/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.transform.S3ObjectMarshaller;
import java.io.Serializable;

public class S3Object
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucket;
    private String key;
    private String etag;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public S3Object withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public S3Object withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public String getEtag() {
        return this.etag;
    }

    public S3Object withEtag(String etag) {
        this.setEtag(etag);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getEtag() != null) {
            sb.append("Etag: ").append(this.getEtag());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Object)) {
            return false;
        }
        S3Object other = (S3Object)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getEtag() == null ^ this.getEtag() == null) {
            return false;
        }
        return other.getEtag() == null || other.getEtag().equals(this.getEtag());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getEtag() == null ? 0 : this.getEtag().hashCode());
        return hashCode;
    }

    public S3Object clone() {
        try {
            return (S3Object)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

