/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.robomaker.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.robomaker.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DeploymentConfigMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DeploymentConfigMarshaller {

    private static final MarshallingInfo<Integer> CONCURRENTDEPLOYMENTPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("concurrentDeploymentPercentage").build();
    private static final MarshallingInfo<Integer> FAILURETHRESHOLDPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureThresholdPercentage").build();
    private static final MarshallingInfo<Long> ROBOTDEPLOYMENTTIMEOUTINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("robotDeploymentTimeoutInSeconds").build();
    private static final MarshallingInfo<StructuredPojo> DOWNLOADCONDITIONFILE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downloadConditionFile").build();

    private static final DeploymentConfigMarshaller instance = new DeploymentConfigMarshaller();

    public static DeploymentConfigMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DeploymentConfig deploymentConfig, ProtocolMarshaller protocolMarshaller) {

        if (deploymentConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(deploymentConfig.getConcurrentDeploymentPercentage(), CONCURRENTDEPLOYMENTPERCENTAGE_BINDING);
            protocolMarshaller.marshall(deploymentConfig.getFailureThresholdPercentage(), FAILURETHRESHOLDPERCENTAGE_BINDING);
            protocolMarshaller.marshall(deploymentConfig.getRobotDeploymentTimeoutInSeconds(), ROBOTDEPLOYMENTTIMEOUTINSECONDS_BINDING);
            protocolMarshaller.marshall(deploymentConfig.getDownloadConditionFile(), DOWNLOADCONDITIONFILE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
