/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.model.AmazonRoute53DomainsException;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityRequest;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityResult;
import com.amazonaws.services.route53domains.model.DeleteTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.DeleteTagsForDomainResult;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewResult;
import com.amazonaws.services.route53domains.model.DisableDomainTransferLockRequest;
import com.amazonaws.services.route53domains.model.DisableDomainTransferLockResult;
import com.amazonaws.services.route53domains.model.DomainLimitExceededException;
import com.amazonaws.services.route53domains.model.DuplicateRequestException;
import com.amazonaws.services.route53domains.model.EnableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.EnableDomainAutoRenewResult;
import com.amazonaws.services.route53domains.model.EnableDomainTransferLockRequest;
import com.amazonaws.services.route53domains.model.EnableDomainTransferLockResult;
import com.amazonaws.services.route53domains.model.GetContactReachabilityStatusRequest;
import com.amazonaws.services.route53domains.model.GetContactReachabilityStatusResult;
import com.amazonaws.services.route53domains.model.GetDomainDetailRequest;
import com.amazonaws.services.route53domains.model.GetDomainDetailResult;
import com.amazonaws.services.route53domains.model.GetDomainSuggestionsRequest;
import com.amazonaws.services.route53domains.model.GetDomainSuggestionsResult;
import com.amazonaws.services.route53domains.model.GetOperationDetailRequest;
import com.amazonaws.services.route53domains.model.GetOperationDetailResult;
import com.amazonaws.services.route53domains.model.InvalidInputException;
import com.amazonaws.services.route53domains.model.ListDomainsRequest;
import com.amazonaws.services.route53domains.model.ListDomainsResult;
import com.amazonaws.services.route53domains.model.ListOperationsRequest;
import com.amazonaws.services.route53domains.model.ListOperationsResult;
import com.amazonaws.services.route53domains.model.ListTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.ListTagsForDomainResult;
import com.amazonaws.services.route53domains.model.OperationLimitExceededException;
import com.amazonaws.services.route53domains.model.RegisterDomainRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainResult;
import com.amazonaws.services.route53domains.model.RenewDomainRequest;
import com.amazonaws.services.route53domains.model.RenewDomainResult;
import com.amazonaws.services.route53domains.model.ResendContactReachabilityEmailRequest;
import com.amazonaws.services.route53domains.model.ResendContactReachabilityEmailResult;
import com.amazonaws.services.route53domains.model.RetrieveDomainAuthCodeRequest;
import com.amazonaws.services.route53domains.model.RetrieveDomainAuthCodeResult;
import com.amazonaws.services.route53domains.model.TLDRulesViolationException;
import com.amazonaws.services.route53domains.model.TransferDomainRequest;
import com.amazonaws.services.route53domains.model.TransferDomainResult;
import com.amazonaws.services.route53domains.model.UnsupportedTLDException;
import com.amazonaws.services.route53domains.model.UpdateDomainContactPrivacyRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainContactPrivacyResult;
import com.amazonaws.services.route53domains.model.UpdateDomainContactRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainContactResult;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversResult;
import com.amazonaws.services.route53domains.model.UpdateTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.UpdateTagsForDomainResult;
import com.amazonaws.services.route53domains.model.ViewBillingRequest;
import com.amazonaws.services.route53domains.model.ViewBillingResult;
import com.amazonaws.services.route53domains.model.transform.CheckDomainAvailabilityRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.CheckDomainAvailabilityResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DeleteTagsForDomainRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.DeleteTagsForDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainAutoRenewRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainAutoRenewResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainTransferLockRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainTransferLockResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainAutoRenewRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainAutoRenewResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainTransferLockRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainTransferLockResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetContactReachabilityStatusRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetContactReachabilityStatusResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainDetailRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainDetailResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainSuggestionsRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainSuggestionsResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetOperationDetailRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetOperationDetailResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.ListDomainsResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ListOperationsRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.ListOperationsResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ListTagsForDomainRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.ListTagsForDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.RegisterDomainRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.RegisterDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.RenewDomainRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.RenewDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ResendContactReachabilityEmailRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.ResendContactReachabilityEmailResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.RetrieveDomainAuthCodeRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.RetrieveDomainAuthCodeResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.TransferDomainRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.TransferDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactPrivacyRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactPrivacyResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainNameserversRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainNameserversResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateTagsForDomainRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateTagsForDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ViewBillingRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.ViewBillingResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonRoute53DomainsClient
extends AmazonWebServiceClient
implements AmazonRoute53Domains {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonRoute53Domains.class);
    private static final String DEFAULT_SIGNING_NAME = "route53domains";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInput").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TLDRulesViolation").withModeledClass(TLDRulesViolationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DomainLimitExceeded").withModeledClass(DomainLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedTLD").withModeledClass(UnsupportedTLDException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationLimitExceeded").withModeledClass(OperationLimitExceededException.class)).withBaseServiceExceptionClass(AmazonRoute53DomainsException.class));

    public AmazonRoute53DomainsClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    public AmazonRoute53DomainsClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    public AmazonRoute53DomainsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonRoute53DomainsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AmazonRoute53DomainsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://route53domains.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53domains/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/route53domains/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckDomainAvailabilityResult checkDomainAvailability(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(checkDomainAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CheckDomainAvailabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CheckDomainAvailabilityRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((CheckDomainAvailabilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)checkDomainAvailabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CheckDomainAvailabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CheckDomainAvailabilityResult checkDomainAvailabilityResult = (CheckDomainAvailabilityResult)response.getAwsResponse();
            return checkDomainAvailabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsForDomainResult deleteTagsForDomain(DeleteTagsForDomainRequest deleteTagsForDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsForDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTagsForDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTagsForDomainRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteTagsForDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTagsForDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTagsForDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTagsForDomainResult deleteTagsForDomainResult = (DeleteTagsForDomainResult)response.getAwsResponse();
            return deleteTagsForDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDomainAutoRenewResult disableDomainAutoRenew(DisableDomainAutoRenewRequest disableDomainAutoRenewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableDomainAutoRenewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableDomainAutoRenewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableDomainAutoRenewRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DisableDomainAutoRenewRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableDomainAutoRenewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableDomainAutoRenewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableDomainAutoRenewResult disableDomainAutoRenewResult = (DisableDomainAutoRenewResult)response.getAwsResponse();
            return disableDomainAutoRenewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDomainTransferLockResult disableDomainTransferLock(DisableDomainTransferLockRequest disableDomainTransferLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableDomainTransferLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableDomainTransferLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableDomainTransferLockRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DisableDomainTransferLockRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableDomainTransferLockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableDomainTransferLockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableDomainTransferLockResult disableDomainTransferLockResult = (DisableDomainTransferLockResult)response.getAwsResponse();
            return disableDomainTransferLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDomainAutoRenewResult enableDomainAutoRenew(EnableDomainAutoRenewRequest enableDomainAutoRenewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableDomainAutoRenewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableDomainAutoRenewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableDomainAutoRenewRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((EnableDomainAutoRenewRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableDomainAutoRenewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableDomainAutoRenewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableDomainAutoRenewResult enableDomainAutoRenewResult = (EnableDomainAutoRenewResult)response.getAwsResponse();
            return enableDomainAutoRenewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDomainTransferLockResult enableDomainTransferLock(EnableDomainTransferLockRequest enableDomainTransferLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableDomainTransferLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableDomainTransferLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableDomainTransferLockRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((EnableDomainTransferLockRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableDomainTransferLockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableDomainTransferLockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableDomainTransferLockResult enableDomainTransferLockResult = (EnableDomainTransferLockResult)response.getAwsResponse();
            return enableDomainTransferLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContactReachabilityStatusResult getContactReachabilityStatus(GetContactReachabilityStatusRequest getContactReachabilityStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getContactReachabilityStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetContactReachabilityStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetContactReachabilityStatusRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetContactReachabilityStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getContactReachabilityStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetContactReachabilityStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetContactReachabilityStatusResult getContactReachabilityStatusResult = (GetContactReachabilityStatusResult)response.getAwsResponse();
            return getContactReachabilityStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainDetailResult getDomainDetail(GetDomainDetailRequest getDomainDetailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDomainDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDomainDetailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDomainDetailRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetDomainDetailRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDomainDetailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDomainDetailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDomainDetailResult getDomainDetailResult = (GetDomainDetailResult)response.getAwsResponse();
            return getDomainDetailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainSuggestionsResult getDomainSuggestions(GetDomainSuggestionsRequest getDomainSuggestionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDomainSuggestionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDomainSuggestionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDomainSuggestionsRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetDomainSuggestionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDomainSuggestionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDomainSuggestionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDomainSuggestionsResult getDomainSuggestionsResult = (GetDomainSuggestionsResult)response.getAwsResponse();
            return getDomainSuggestionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperationDetailResult getOperationDetail(GetOperationDetailRequest getOperationDetailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOperationDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOperationDetailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOperationDetailRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetOperationDetailRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOperationDetailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOperationDetailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOperationDetailResult getOperationDetailResult = (GetOperationDetailResult)response.getAwsResponse();
            return getOperationDetailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainsResult listDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListDomainsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDomainsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDomainsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDomainsResult listDomainsResult = (ListDomainsResult)response.getAwsResponse();
            return listDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainsResult listDomains() {
        return this.listDomains(new ListDomainsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOperationsResult listOperations(ListOperationsRequest listOperationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOperationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOperationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOperationsRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListOperationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOperationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOperationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOperationsResult listOperationsResult = (ListOperationsResult)response.getAwsResponse();
            return listOperationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOperationsResult listOperations() {
        return this.listOperations(new ListOperationsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForDomainResult listTagsForDomain(ListTagsForDomainRequest listTagsForDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForDomainRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListTagsForDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForDomainResult listTagsForDomainResult = (ListTagsForDomainResult)response.getAwsResponse();
            return listTagsForDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterDomainResult registerDomain(RegisterDomainRequest registerDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterDomainRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((RegisterDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterDomainResult registerDomainResult = (RegisterDomainResult)response.getAwsResponse();
            return registerDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenewDomainResult renewDomain(RenewDomainRequest renewDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(renewDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RenewDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RenewDomainRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((RenewDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)renewDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RenewDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RenewDomainResult renewDomainResult = (RenewDomainResult)response.getAwsResponse();
            return renewDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResendContactReachabilityEmailResult resendContactReachabilityEmail(ResendContactReachabilityEmailRequest resendContactReachabilityEmailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resendContactReachabilityEmailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResendContactReachabilityEmailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResendContactReachabilityEmailRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ResendContactReachabilityEmailRequest)super.beforeMarshalling((AmazonWebServiceRequest)resendContactReachabilityEmailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResendContactReachabilityEmailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResendContactReachabilityEmailResult resendContactReachabilityEmailResult = (ResendContactReachabilityEmailResult)response.getAwsResponse();
            return resendContactReachabilityEmailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetrieveDomainAuthCodeResult retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest retrieveDomainAuthCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retrieveDomainAuthCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RetrieveDomainAuthCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RetrieveDomainAuthCodeRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((RetrieveDomainAuthCodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)retrieveDomainAuthCodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RetrieveDomainAuthCodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RetrieveDomainAuthCodeResult retrieveDomainAuthCodeResult = (RetrieveDomainAuthCodeResult)response.getAwsResponse();
            return retrieveDomainAuthCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferDomainResult transferDomain(TransferDomainRequest transferDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(transferDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TransferDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TransferDomainRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((TransferDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)transferDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TransferDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TransferDomainResult transferDomainResult = (TransferDomainResult)response.getAwsResponse();
            return transferDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainContactResult updateDomainContact(UpdateDomainContactRequest updateDomainContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainContactRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateDomainContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDomainContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDomainContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainContactResult updateDomainContactResult = (UpdateDomainContactResult)response.getAwsResponse();
            return updateDomainContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainContactPrivacyResult updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest updateDomainContactPrivacyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainContactPrivacyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainContactPrivacyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainContactPrivacyRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateDomainContactPrivacyRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDomainContactPrivacyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDomainContactPrivacyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainContactPrivacyResult updateDomainContactPrivacyResult = (UpdateDomainContactPrivacyResult)response.getAwsResponse();
            return updateDomainContactPrivacyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainNameserversResult updateDomainNameservers(UpdateDomainNameserversRequest updateDomainNameserversRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainNameserversRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainNameserversRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainNameserversRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateDomainNameserversRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDomainNameserversRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDomainNameserversResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainNameserversResult updateDomainNameserversResult = (UpdateDomainNameserversResult)response.getAwsResponse();
            return updateDomainNameserversResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTagsForDomainResult updateTagsForDomain(UpdateTagsForDomainRequest updateTagsForDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTagsForDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTagsForDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTagsForDomainRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateTagsForDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTagsForDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTagsForDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTagsForDomainResult updateTagsForDomainResult = (UpdateTagsForDomainResult)response.getAwsResponse();
            return updateTagsForDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ViewBillingResult viewBilling(ViewBillingRequest viewBillingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(viewBillingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ViewBillingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ViewBillingRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ViewBillingRequest)super.beforeMarshalling((AmazonWebServiceRequest)viewBillingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ViewBillingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ViewBillingResult viewBillingResult = (ViewBillingResult)response.getAwsResponse();
            return viewBillingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

