/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Route 53 is a highly available and scalable Domain Name System (DNS) web service.
 * </p>
 * <p>
 * You can use Route 53 to:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Register domain names.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-domain-registration.html">How domain
 * registration works</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Route internet traffic to the resources for your domain
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">How internet traffic is
 * routed to your website or web application</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Check the health of your resources.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-health-checks.html">How Route 53 checks the
 * health of your resources</a>.
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.route53;

