/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoverycluster;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.route53recoverycluster.AWSRoute53RecoveryClusterAsync;
import com.amazonaws.services.route53recoverycluster.AWSRoute53RecoveryClusterAsyncClientBuilder;
import com.amazonaws.services.route53recoverycluster.AWSRoute53RecoveryClusterClient;
import com.amazonaws.services.route53recoverycluster.model.GetRoutingControlStateRequest;
import com.amazonaws.services.route53recoverycluster.model.GetRoutingControlStateResult;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStateRequest;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStateResult;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStatesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSRoute53RecoveryClusterAsyncClient
extends AWSRoute53RecoveryClusterClient
implements AWSRoute53RecoveryClusterAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSRoute53RecoveryClusterAsyncClientBuilder asyncBuilder() {
        return AWSRoute53RecoveryClusterAsyncClientBuilder.standard();
    }

    AWSRoute53RecoveryClusterAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSRoute53RecoveryClusterAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetRoutingControlStateResult> getRoutingControlStateAsync(GetRoutingControlStateRequest request) {
        return this.getRoutingControlStateAsync(request, null);
    }

    @Override
    public Future<GetRoutingControlStateResult> getRoutingControlStateAsync(GetRoutingControlStateRequest request, final AsyncHandler<GetRoutingControlStateRequest, GetRoutingControlStateResult> asyncHandler) {
        final GetRoutingControlStateRequest finalRequest = (GetRoutingControlStateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRoutingControlStateResult>(){

            @Override
            public GetRoutingControlStateResult call() throws Exception {
                GetRoutingControlStateResult result = null;
                try {
                    result = AWSRoute53RecoveryClusterAsyncClient.this.executeGetRoutingControlState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRoutingControlStateResult> updateRoutingControlStateAsync(UpdateRoutingControlStateRequest request) {
        return this.updateRoutingControlStateAsync(request, null);
    }

    @Override
    public Future<UpdateRoutingControlStateResult> updateRoutingControlStateAsync(UpdateRoutingControlStateRequest request, final AsyncHandler<UpdateRoutingControlStateRequest, UpdateRoutingControlStateResult> asyncHandler) {
        final UpdateRoutingControlStateRequest finalRequest = (UpdateRoutingControlStateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRoutingControlStateResult>(){

            @Override
            public UpdateRoutingControlStateResult call() throws Exception {
                UpdateRoutingControlStateResult result = null;
                try {
                    result = AWSRoute53RecoveryClusterAsyncClient.this.executeUpdateRoutingControlState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRoutingControlStatesResult> updateRoutingControlStatesAsync(UpdateRoutingControlStatesRequest request) {
        return this.updateRoutingControlStatesAsync(request, null);
    }

    @Override
    public Future<UpdateRoutingControlStatesResult> updateRoutingControlStatesAsync(UpdateRoutingControlStatesRequest request, final AsyncHandler<UpdateRoutingControlStatesRequest, UpdateRoutingControlStatesResult> asyncHandler) {
        final UpdateRoutingControlStatesRequest finalRequest = (UpdateRoutingControlStatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRoutingControlStatesResult>(){

            @Override
            public UpdateRoutingControlStatesResult call() throws Exception {
                UpdateRoutingControlStatesResult result = null;
                try {
                    result = AWSRoute53RecoveryClusterAsyncClient.this.executeUpdateRoutingControlStates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

