/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53recoverycontrolconfig;

import javax.annotation.Generated;

import com.amazonaws.services.route53recoverycontrolconfig.model.*;
import com.amazonaws.*;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.AWSRoute53RecoveryControlConfigWaiters;

/**
 * Abstract implementation of {@code AWSRoute53RecoveryControlConfig}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSRoute53RecoveryControlConfig implements AWSRoute53RecoveryControlConfig {

    protected AbstractAWSRoute53RecoveryControlConfig() {
    }

    @Override
    public CreateClusterResult createCluster(CreateClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateControlPanelResult createControlPanel(CreateControlPanelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRoutingControlResult createRoutingControl(CreateRoutingControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSafetyRuleResult createSafetyRule(CreateSafetyRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteControlPanelResult deleteControlPanel(DeleteControlPanelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoutingControlResult deleteRoutingControl(DeleteRoutingControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSafetyRuleResult deleteSafetyRule(DeleteSafetyRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClusterResult describeCluster(DescribeClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeControlPanelResult describeControlPanel(DescribeControlPanelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRoutingControlResult describeRoutingControl(DescribeRoutingControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSafetyRuleResult describeSafetyRule(DescribeSafetyRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssociatedRoute53HealthChecksResult listAssociatedRoute53HealthChecks(ListAssociatedRoute53HealthChecksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClustersResult listClusters(ListClustersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListControlPanelsResult listControlPanels(ListControlPanelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRoutingControlsResult listRoutingControls(ListRoutingControlsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSafetyRulesResult listSafetyRules(ListSafetyRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateControlPanelResult updateControlPanel(UpdateControlPanelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRoutingControlResult updateRoutingControl(UpdateRoutingControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSafetyRuleResult updateSafetyRule(UpdateSafetyRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AWSRoute53RecoveryControlConfigWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
