/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;

public class SkipMd5CheckStrategy {
    public static final String DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY = "com.amazonaws.services.s3.disableGetObjectMD5Validation";
    public static final String DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY = "com.amazonaws.services.s3.disablePutObjectMD5Validation";
    public static final SkipMd5CheckStrategy INSTANCE = new SkipMd5CheckStrategy();

    private SkipMd5CheckStrategy() {
    }

    public boolean skipMd5CheckPerResponse(ObjectMetadata metadata) {
        return metadata != null && (metadata.getSSEAwsKmsKeyId() != null || metadata.getSSECustomerAlgorithm() != null);
    }

    public boolean skipMd5CheckPerRequest(GetObjectRequest request) {
        if (System.getProperty(DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY) != null) {
            return true;
        }
        if (request.getRange() != null) {
            return true;
        }
        return request.getSSECustomerKey() != null;
    }

    public boolean skipMd5CheckPerRequest(PutObjectRequest request) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return request.getSSECustomerKey() != null || request.getSSEAwsKeyManagementParams() != null;
    }

    public boolean skipMd5CheckPerRequest(UploadPartRequest request) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return request.getSSECustomerKey() != null;
    }

    private boolean isPutObjectMd5ValidationDisabledByProperty() {
        return System.getProperty(DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY) != null;
    }
}

