/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.CreateJobRequest;
import com.amazonaws.services.s3control.model.JobManifest;
import com.amazonaws.services.s3control.model.JobManifestLocation;
import com.amazonaws.services.s3control.model.JobManifestSpec;
import com.amazonaws.services.s3control.model.JobOperation;
import com.amazonaws.services.s3control.model.JobReport;
import com.amazonaws.services.s3control.model.LambdaInvokeOperation;
import com.amazonaws.services.s3control.model.S3AccessControlList;
import com.amazonaws.services.s3control.model.S3AccessControlPolicy;
import com.amazonaws.services.s3control.model.S3CopyObjectOperation;
import com.amazonaws.services.s3control.model.S3DeleteObjectTaggingOperation;
import com.amazonaws.services.s3control.model.S3Grant;
import com.amazonaws.services.s3control.model.S3Grantee;
import com.amazonaws.services.s3control.model.S3InitiateRestoreObjectOperation;
import com.amazonaws.services.s3control.model.S3ObjectLockLegalHold;
import com.amazonaws.services.s3control.model.S3ObjectMetadata;
import com.amazonaws.services.s3control.model.S3ObjectOwner;
import com.amazonaws.services.s3control.model.S3Retention;
import com.amazonaws.services.s3control.model.S3SetObjectAclOperation;
import com.amazonaws.services.s3control.model.S3SetObjectLegalHoldOperation;
import com.amazonaws.services.s3control.model.S3SetObjectRetentionOperation;
import com.amazonaws.services.s3control.model.S3SetObjectTaggingOperation;
import com.amazonaws.services.s3control.model.S3Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createJobRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (createJobRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)createJobRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/jobs";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("CreateJobRequest");
            if (createJobRequest != null) {
                List<S3Tag> createJobRequestTagsList;
                JobReport report;
                JobOperation operation;
                if (createJobRequest.getConfirmationRequired() != null) {
                    xmlWriter.startElement("ConfirmationRequired").value((Object)createJobRequest.getConfirmationRequired()).endElement();
                }
                if ((operation = createJobRequest.getOperation()) != null) {
                    S3SetObjectRetentionOperation s3PutObjectRetention;
                    S3SetObjectLegalHoldOperation s3PutObjectLegalHold;
                    S3InitiateRestoreObjectOperation s3InitiateRestoreObject;
                    S3DeleteObjectTaggingOperation s3DeleteObjectTagging;
                    S3SetObjectTaggingOperation s3PutObjectTagging;
                    S3SetObjectAclOperation s3PutObjectAcl;
                    S3CopyObjectOperation s3PutObjectCopy;
                    xmlWriter.startElement("Operation");
                    LambdaInvokeOperation lambdaInvoke = operation.getLambdaInvoke();
                    if (lambdaInvoke != null) {
                        xmlWriter.startElement("LambdaInvoke");
                        if (lambdaInvoke.getFunctionArn() != null) {
                            xmlWriter.startElement("FunctionArn").value(lambdaInvoke.getFunctionArn()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((s3PutObjectCopy = operation.getS3PutObjectCopy()) != null) {
                        List<S3Tag> s3CopyObjectOperationNewObjectTaggingList;
                        S3ObjectMetadata newObjectMetadata;
                        List<S3Grant> s3CopyObjectOperationAccessControlGrantsList;
                        xmlWriter.startElement("S3PutObjectCopy");
                        if (s3PutObjectCopy.getTargetResource() != null) {
                            xmlWriter.startElement("TargetResource").value(s3PutObjectCopy.getTargetResource()).endElement();
                        }
                        if (s3PutObjectCopy.getCannedAccessControlList() != null) {
                            xmlWriter.startElement("CannedAccessControlList").value(s3PutObjectCopy.getCannedAccessControlList()).endElement();
                        }
                        if ((s3CopyObjectOperationAccessControlGrantsList = s3PutObjectCopy.getAccessControlGrants()) != null) {
                            xmlWriter.startElement("AccessControlGrants");
                            for (S3Grant s3CopyObjectOperationAccessControlGrantsListValue : s3CopyObjectOperationAccessControlGrantsList) {
                                xmlWriter.startElement("member");
                                S3Grantee grantee = s3CopyObjectOperationAccessControlGrantsListValue.getGrantee();
                                if (grantee != null) {
                                    xmlWriter.startElement("Grantee");
                                    if (grantee.getTypeIdentifier() != null) {
                                        xmlWriter.startElement("TypeIdentifier").value(grantee.getTypeIdentifier()).endElement();
                                    }
                                    if (grantee.getIdentifier() != null) {
                                        xmlWriter.startElement("Identifier").value(grantee.getIdentifier()).endElement();
                                    }
                                    if (grantee.getDisplayName() != null) {
                                        xmlWriter.startElement("DisplayName").value(grantee.getDisplayName()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if (s3CopyObjectOperationAccessControlGrantsListValue.getPermission() != null) {
                                    xmlWriter.startElement("Permission").value(s3CopyObjectOperationAccessControlGrantsListValue.getPermission()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (s3PutObjectCopy.getMetadataDirective() != null) {
                            xmlWriter.startElement("MetadataDirective").value(s3PutObjectCopy.getMetadataDirective()).endElement();
                        }
                        if (s3PutObjectCopy.getModifiedSinceConstraint() != null) {
                            xmlWriter.startElement("ModifiedSinceConstraint").value(s3PutObjectCopy.getModifiedSinceConstraint()).endElement();
                        }
                        if ((newObjectMetadata = s3PutObjectCopy.getNewObjectMetadata()) != null) {
                            Object s3ObjectMetadataUserMetadataMap;
                            xmlWriter.startElement("NewObjectMetadata");
                            if (newObjectMetadata.getCacheControl() != null) {
                                xmlWriter.startElement("CacheControl").value(newObjectMetadata.getCacheControl()).endElement();
                            }
                            if (newObjectMetadata.getContentDisposition() != null) {
                                xmlWriter.startElement("ContentDisposition").value(newObjectMetadata.getContentDisposition()).endElement();
                            }
                            if (newObjectMetadata.getContentEncoding() != null) {
                                xmlWriter.startElement("ContentEncoding").value(newObjectMetadata.getContentEncoding()).endElement();
                            }
                            if (newObjectMetadata.getContentLanguage() != null) {
                                xmlWriter.startElement("ContentLanguage").value(newObjectMetadata.getContentLanguage()).endElement();
                            }
                            if ((s3ObjectMetadataUserMetadataMap = (HashMap)newObjectMetadata.getUserMetadata()) != null) {
                                xmlWriter.startElement("UserMetadata");
                                for (Map.Entry entry : ((HashMap)s3ObjectMetadataUserMetadataMap).entrySet()) {
                                    if (entry == null) continue;
                                    xmlWriter.startElement("entry");
                                    xmlWriter.startElement("key");
                                    xmlWriter.value((String)entry.getKey());
                                    xmlWriter.endElement();
                                    xmlWriter.startElement("value");
                                    xmlWriter.value((String)entry.getValue());
                                    xmlWriter.endElement();
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (newObjectMetadata.getContentLength() != null) {
                                xmlWriter.startElement("ContentLength").value((Object)newObjectMetadata.getContentLength()).endElement();
                            }
                            if (newObjectMetadata.getContentMD5() != null) {
                                xmlWriter.startElement("ContentMD5").value(newObjectMetadata.getContentMD5()).endElement();
                            }
                            if (newObjectMetadata.getContentType() != null) {
                                xmlWriter.startElement("ContentType").value(newObjectMetadata.getContentType()).endElement();
                            }
                            if (newObjectMetadata.getHttpExpiresDate() != null) {
                                xmlWriter.startElement("HttpExpiresDate").value(newObjectMetadata.getHttpExpiresDate()).endElement();
                            }
                            if (newObjectMetadata.getRequesterCharged() != null) {
                                xmlWriter.startElement("RequesterCharged").value((Object)newObjectMetadata.getRequesterCharged()).endElement();
                            }
                            if (newObjectMetadata.getSSEAlgorithm() != null) {
                                xmlWriter.startElement("SSEAlgorithm").value(newObjectMetadata.getSSEAlgorithm()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((s3CopyObjectOperationNewObjectTaggingList = s3PutObjectCopy.getNewObjectTagging()) != null) {
                            xmlWriter.startElement("NewObjectTagging");
                            for (S3Tag s3CopyObjectOperationNewObjectTaggingListValue : s3CopyObjectOperationNewObjectTaggingList) {
                                xmlWriter.startElement("member");
                                if (s3CopyObjectOperationNewObjectTaggingListValue.getKey() != null) {
                                    xmlWriter.startElement("Key").value(s3CopyObjectOperationNewObjectTaggingListValue.getKey()).endElement();
                                }
                                if (s3CopyObjectOperationNewObjectTaggingListValue.getValue() != null) {
                                    xmlWriter.startElement("Value").value(s3CopyObjectOperationNewObjectTaggingListValue.getValue()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (s3PutObjectCopy.getRedirectLocation() != null) {
                            xmlWriter.startElement("RedirectLocation").value(s3PutObjectCopy.getRedirectLocation()).endElement();
                        }
                        if (s3PutObjectCopy.getRequesterPays() != null) {
                            xmlWriter.startElement("RequesterPays").value((Object)s3PutObjectCopy.getRequesterPays()).endElement();
                        }
                        if (s3PutObjectCopy.getStorageClass() != null) {
                            xmlWriter.startElement("StorageClass").value(s3PutObjectCopy.getStorageClass()).endElement();
                        }
                        if (s3PutObjectCopy.getUnModifiedSinceConstraint() != null) {
                            xmlWriter.startElement("UnModifiedSinceConstraint").value(s3PutObjectCopy.getUnModifiedSinceConstraint()).endElement();
                        }
                        if (s3PutObjectCopy.getSSEAwsKmsKeyId() != null) {
                            xmlWriter.startElement("SSEAwsKmsKeyId").value(s3PutObjectCopy.getSSEAwsKmsKeyId()).endElement();
                        }
                        if (s3PutObjectCopy.getTargetKeyPrefix() != null) {
                            xmlWriter.startElement("TargetKeyPrefix").value(s3PutObjectCopy.getTargetKeyPrefix()).endElement();
                        }
                        if (s3PutObjectCopy.getObjectLockLegalHoldStatus() != null) {
                            xmlWriter.startElement("ObjectLockLegalHoldStatus").value(s3PutObjectCopy.getObjectLockLegalHoldStatus()).endElement();
                        }
                        if (s3PutObjectCopy.getObjectLockMode() != null) {
                            xmlWriter.startElement("ObjectLockMode").value(s3PutObjectCopy.getObjectLockMode()).endElement();
                        }
                        if (s3PutObjectCopy.getObjectLockRetainUntilDate() != null) {
                            xmlWriter.startElement("ObjectLockRetainUntilDate").value(s3PutObjectCopy.getObjectLockRetainUntilDate()).endElement();
                        }
                        if (s3PutObjectCopy.getBucketKeyEnabled() != null) {
                            xmlWriter.startElement("BucketKeyEnabled").value((Object)s3PutObjectCopy.getBucketKeyEnabled()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((s3PutObjectAcl = operation.getS3PutObjectAcl()) != null) {
                        xmlWriter.startElement("S3PutObjectAcl");
                        S3AccessControlPolicy accessControlPolicy = s3PutObjectAcl.getAccessControlPolicy();
                        if (accessControlPolicy != null) {
                            xmlWriter.startElement("AccessControlPolicy");
                            S3AccessControlList accessControlList = accessControlPolicy.getAccessControlList();
                            if (accessControlList != null) {
                                List<S3Grant> s3AccessControlListGrantsList;
                                xmlWriter.startElement("AccessControlList");
                                S3ObjectOwner owner = accessControlList.getOwner();
                                if (owner != null) {
                                    xmlWriter.startElement("Owner");
                                    if (owner.getID() != null) {
                                        xmlWriter.startElement("ID").value(owner.getID()).endElement();
                                    }
                                    if (owner.getDisplayName() != null) {
                                        xmlWriter.startElement("DisplayName").value(owner.getDisplayName()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((s3AccessControlListGrantsList = accessControlList.getGrants()) != null) {
                                    xmlWriter.startElement("Grants");
                                    for (S3Grant s3Grant : s3AccessControlListGrantsList) {
                                        xmlWriter.startElement("member");
                                        S3Grantee grantee = s3Grant.getGrantee();
                                        if (grantee != null) {
                                            xmlWriter.startElement("Grantee");
                                            if (grantee.getTypeIdentifier() != null) {
                                                xmlWriter.startElement("TypeIdentifier").value(grantee.getTypeIdentifier()).endElement();
                                            }
                                            if (grantee.getIdentifier() != null) {
                                                xmlWriter.startElement("Identifier").value(grantee.getIdentifier()).endElement();
                                            }
                                            if (grantee.getDisplayName() != null) {
                                                xmlWriter.startElement("DisplayName").value(grantee.getDisplayName()).endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        if (s3Grant.getPermission() != null) {
                                            xmlWriter.startElement("Permission").value(s3Grant.getPermission()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (accessControlPolicy.getCannedAccessControlList() != null) {
                                xmlWriter.startElement("CannedAccessControlList").value(accessControlPolicy.getCannedAccessControlList()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((s3PutObjectTagging = operation.getS3PutObjectTagging()) != null) {
                        xmlWriter.startElement("S3PutObjectTagging");
                        List<S3Tag> s3SetObjectTaggingOperationTagSetList = s3PutObjectTagging.getTagSet();
                        if (s3SetObjectTaggingOperationTagSetList != null) {
                            xmlWriter.startElement("TagSet");
                            for (S3Tag s3SetObjectTaggingOperationTagSetListValue : s3SetObjectTaggingOperationTagSetList) {
                                xmlWriter.startElement("member");
                                if (s3SetObjectTaggingOperationTagSetListValue.getKey() != null) {
                                    xmlWriter.startElement("Key").value(s3SetObjectTaggingOperationTagSetListValue.getKey()).endElement();
                                }
                                if (s3SetObjectTaggingOperationTagSetListValue.getValue() != null) {
                                    xmlWriter.startElement("Value").value(s3SetObjectTaggingOperationTagSetListValue.getValue()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((s3DeleteObjectTagging = operation.getS3DeleteObjectTagging()) != null) {
                        xmlWriter.startElement("S3DeleteObjectTagging");
                        xmlWriter.endElement();
                    }
                    if ((s3InitiateRestoreObject = operation.getS3InitiateRestoreObject()) != null) {
                        xmlWriter.startElement("S3InitiateRestoreObject");
                        if (s3InitiateRestoreObject.getExpirationInDays() != null) {
                            xmlWriter.startElement("ExpirationInDays").value((Object)s3InitiateRestoreObject.getExpirationInDays()).endElement();
                        }
                        if (s3InitiateRestoreObject.getGlacierJobTier() != null) {
                            xmlWriter.startElement("GlacierJobTier").value(s3InitiateRestoreObject.getGlacierJobTier()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((s3PutObjectLegalHold = operation.getS3PutObjectLegalHold()) != null) {
                        xmlWriter.startElement("S3PutObjectLegalHold");
                        S3ObjectLockLegalHold legalHold = s3PutObjectLegalHold.getLegalHold();
                        if (legalHold != null) {
                            xmlWriter.startElement("LegalHold");
                            if (legalHold.getStatus() != null) {
                                xmlWriter.startElement("Status").value(legalHold.getStatus()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((s3PutObjectRetention = operation.getS3PutObjectRetention()) != null) {
                        S3Retention retention;
                        xmlWriter.startElement("S3PutObjectRetention");
                        if (s3PutObjectRetention.getBypassGovernanceRetention() != null) {
                            xmlWriter.startElement("BypassGovernanceRetention").value((Object)s3PutObjectRetention.getBypassGovernanceRetention()).endElement();
                        }
                        if ((retention = s3PutObjectRetention.getRetention()) != null) {
                            xmlWriter.startElement("Retention");
                            if (retention.getRetainUntilDate() != null) {
                                xmlWriter.startElement("RetainUntilDate").value(retention.getRetainUntilDate()).endElement();
                            }
                            if (retention.getMode() != null) {
                                xmlWriter.startElement("Mode").value(retention.getMode()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((report = createJobRequest.getReport()) != null) {
                    xmlWriter.startElement("Report");
                    if (report.getBucket() != null) {
                        xmlWriter.startElement("Bucket").value(report.getBucket()).endElement();
                    }
                    if (report.getFormat() != null) {
                        xmlWriter.startElement("Format").value(report.getFormat()).endElement();
                    }
                    if (report.getEnabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)report.getEnabled()).endElement();
                    }
                    if (report.getPrefix() != null) {
                        xmlWriter.startElement("Prefix").value(report.getPrefix()).endElement();
                    }
                    if (report.getReportScope() != null) {
                        xmlWriter.startElement("ReportScope").value(report.getReportScope()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.startElement("ClientRequestToken").value(IdempotentUtils.resolveString((String)createJobRequest.getClientRequestToken())).endElement();
                JobManifest manifest = createJobRequest.getManifest();
                if (manifest != null) {
                    JobManifestLocation location;
                    xmlWriter.startElement("Manifest");
                    JobManifestSpec spec = manifest.getSpec();
                    if (spec != null) {
                        List<String> jobManifestSpecFieldsList;
                        xmlWriter.startElement("Spec");
                        if (spec.getFormat() != null) {
                            xmlWriter.startElement("Format").value(spec.getFormat()).endElement();
                        }
                        if ((jobManifestSpecFieldsList = spec.getFields()) != null) {
                            xmlWriter.startElement("Fields");
                            for (String jobManifestSpecFieldsListValue : jobManifestSpecFieldsList) {
                                xmlWriter.startElement("member");
                                xmlWriter.value(jobManifestSpecFieldsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((location = manifest.getLocation()) != null) {
                        xmlWriter.startElement("Location");
                        if (location.getObjectArn() != null) {
                            xmlWriter.startElement("ObjectArn").value(location.getObjectArn()).endElement();
                        }
                        if (location.getObjectVersionId() != null) {
                            xmlWriter.startElement("ObjectVersionId").value(location.getObjectVersionId()).endElement();
                        }
                        if (location.getETag() != null) {
                            xmlWriter.startElement("ETag").value(location.getETag()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createJobRequest.getDescription() != null) {
                    xmlWriter.startElement("Description").value(createJobRequest.getDescription()).endElement();
                }
                if (createJobRequest.getPriority() != null) {
                    xmlWriter.startElement("Priority").value((Object)createJobRequest.getPriority()).endElement();
                }
                if (createJobRequest.getRoleArn() != null) {
                    xmlWriter.startElement("RoleArn").value(createJobRequest.getRoleArn()).endElement();
                }
                if ((createJobRequestTagsList = createJobRequest.getTags()) != null) {
                    xmlWriter.startElement("Tags");
                    for (S3Tag createJobRequestTagsListValue : createJobRequestTagsList) {
                        xmlWriter.startElement("member");
                        if (createJobRequestTagsListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(createJobRequestTagsListValue.getKey()).endElement();
                        }
                        if (createJobRequestTagsListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(createJobRequestTagsListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

