/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.RegionReport;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RegionReportStaxUnmarshaller
implements Unmarshaller<RegionReport, StaxUnmarshallerContext> {
    private static RegionReportStaxUnmarshaller instance;

    public RegionReport unmarshall(StaxUnmarshallerContext context) throws Exception {
        RegionReport regionReport = new RegionReport();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return regionReport;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Bucket", targetDepth)) {
                    regionReport.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Region", targetDepth)) continue;
                regionReport.setRegion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return regionReport;
    }

    public static RegionReportStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RegionReportStaxUnmarshaller();
        }
        return instance;
    }
}

