/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.s3control.model.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.s3control.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListAccessGrantsInstancesResult StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListAccessGrantsInstancesResultStaxUnmarshaller implements Unmarshaller<ListAccessGrantsInstancesResult, StaxUnmarshallerContext> {

    public ListAccessGrantsInstancesResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListAccessGrantsInstancesResult listAccessGrantsInstancesResult = new ListAccessGrantsInstancesResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return listAccessGrantsInstancesResult;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("NextToken", targetDepth)) {
                    listAccessGrantsInstancesResult.setNextToken(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AccessGrantsInstancesList", targetDepth)) {
                    listAccessGrantsInstancesResult.withAccessGrantsInstancesList(new ArrayList<ListAccessGrantsInstanceEntry>());
                    continue;
                }

                if (context.testExpression("AccessGrantsInstancesList/AccessGrantsInstance", targetDepth)) {
                    listAccessGrantsInstancesResult.withAccessGrantsInstancesList(ListAccessGrantsInstanceEntryStaxUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return listAccessGrantsInstancesResult;
                }
            }
        }
    }

    private static ListAccessGrantsInstancesResultStaxUnmarshaller instance;

    public static ListAccessGrantsInstancesResultStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new ListAccessGrantsInstancesResultStaxUnmarshaller();
        return instance;
    }
}
