/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DeleteBucketReplicationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeleteBucketReplicationRequestMarshaller
implements Marshaller<Request<DeleteBucketReplicationRequest>, DeleteBucketReplicationRequest> {
    public Request<DeleteBucketReplicationRequest> marshall(DeleteBucketReplicationRequest deleteBucketReplicationRequest) {
        if (deleteBucketReplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteBucketReplicationRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteBucketReplicationRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)deleteBucketReplicationRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/replication";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", deleteBucketReplicationRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

