/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.ObjectLambdaAllowedFeature;
import com.amazonaws.services.s3control.model.ObjectLambdaTransformationConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectLambdaConfiguration
implements Serializable,
Cloneable {
    private String supportingAccessPoint;
    private Boolean cloudWatchMetricsEnabled;
    private List<String> allowedFeatures;
    private List<ObjectLambdaTransformationConfiguration> transformationConfigurations;

    public void setSupportingAccessPoint(String supportingAccessPoint) {
        this.supportingAccessPoint = supportingAccessPoint;
    }

    public String getSupportingAccessPoint() {
        return this.supportingAccessPoint;
    }

    public ObjectLambdaConfiguration withSupportingAccessPoint(String supportingAccessPoint) {
        this.setSupportingAccessPoint(supportingAccessPoint);
        return this;
    }

    public void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
        this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
    }

    public Boolean getCloudWatchMetricsEnabled() {
        return this.cloudWatchMetricsEnabled;
    }

    public ObjectLambdaConfiguration withCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
        this.setCloudWatchMetricsEnabled(cloudWatchMetricsEnabled);
        return this;
    }

    public Boolean isCloudWatchMetricsEnabled() {
        return this.cloudWatchMetricsEnabled;
    }

    public List<String> getAllowedFeatures() {
        return this.allowedFeatures;
    }

    public void setAllowedFeatures(Collection<String> allowedFeatures) {
        if (allowedFeatures == null) {
            this.allowedFeatures = null;
            return;
        }
        this.allowedFeatures = new ArrayList<String>(allowedFeatures);
    }

    public ObjectLambdaConfiguration withAllowedFeatures(String ... allowedFeatures) {
        if (this.allowedFeatures == null) {
            this.setAllowedFeatures(new ArrayList<String>(allowedFeatures.length));
        }
        for (String ele : allowedFeatures) {
            this.allowedFeatures.add(ele);
        }
        return this;
    }

    public ObjectLambdaConfiguration withAllowedFeatures(Collection<String> allowedFeatures) {
        this.setAllowedFeatures(allowedFeatures);
        return this;
    }

    public ObjectLambdaConfiguration withAllowedFeatures(ObjectLambdaAllowedFeature ... allowedFeatures) {
        ArrayList<String> allowedFeaturesCopy = new ArrayList<String>(allowedFeatures.length);
        for (ObjectLambdaAllowedFeature value : allowedFeatures) {
            allowedFeaturesCopy.add(value.toString());
        }
        if (this.getAllowedFeatures() == null) {
            this.setAllowedFeatures(allowedFeaturesCopy);
        } else {
            this.getAllowedFeatures().addAll(allowedFeaturesCopy);
        }
        return this;
    }

    public List<ObjectLambdaTransformationConfiguration> getTransformationConfigurations() {
        return this.transformationConfigurations;
    }

    public void setTransformationConfigurations(Collection<ObjectLambdaTransformationConfiguration> transformationConfigurations) {
        if (transformationConfigurations == null) {
            this.transformationConfigurations = null;
            return;
        }
        this.transformationConfigurations = new ArrayList<ObjectLambdaTransformationConfiguration>(transformationConfigurations);
    }

    public ObjectLambdaConfiguration withTransformationConfigurations(ObjectLambdaTransformationConfiguration ... transformationConfigurations) {
        if (this.transformationConfigurations == null) {
            this.setTransformationConfigurations(new ArrayList<ObjectLambdaTransformationConfiguration>(transformationConfigurations.length));
        }
        for (ObjectLambdaTransformationConfiguration ele : transformationConfigurations) {
            this.transformationConfigurations.add(ele);
        }
        return this;
    }

    public ObjectLambdaConfiguration withTransformationConfigurations(Collection<ObjectLambdaTransformationConfiguration> transformationConfigurations) {
        this.setTransformationConfigurations(transformationConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSupportingAccessPoint() != null) {
            sb.append("SupportingAccessPoint: ").append(this.getSupportingAccessPoint()).append(",");
        }
        if (this.getCloudWatchMetricsEnabled() != null) {
            sb.append("CloudWatchMetricsEnabled: ").append(this.getCloudWatchMetricsEnabled()).append(",");
        }
        if (this.getAllowedFeatures() != null) {
            sb.append("AllowedFeatures: ").append(this.getAllowedFeatures()).append(",");
        }
        if (this.getTransformationConfigurations() != null) {
            sb.append("TransformationConfigurations: ").append(this.getTransformationConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLambdaConfiguration)) {
            return false;
        }
        ObjectLambdaConfiguration other = (ObjectLambdaConfiguration)obj;
        if (other.getSupportingAccessPoint() == null ^ this.getSupportingAccessPoint() == null) {
            return false;
        }
        if (other.getSupportingAccessPoint() != null && !other.getSupportingAccessPoint().equals(this.getSupportingAccessPoint())) {
            return false;
        }
        if (other.getCloudWatchMetricsEnabled() == null ^ this.getCloudWatchMetricsEnabled() == null) {
            return false;
        }
        if (other.getCloudWatchMetricsEnabled() != null && !other.getCloudWatchMetricsEnabled().equals(this.getCloudWatchMetricsEnabled())) {
            return false;
        }
        if (other.getAllowedFeatures() == null ^ this.getAllowedFeatures() == null) {
            return false;
        }
        if (other.getAllowedFeatures() != null && !other.getAllowedFeatures().equals(this.getAllowedFeatures())) {
            return false;
        }
        if (other.getTransformationConfigurations() == null ^ this.getTransformationConfigurations() == null) {
            return false;
        }
        return other.getTransformationConfigurations() == null || other.getTransformationConfigurations().equals(this.getTransformationConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSupportingAccessPoint() == null ? 0 : this.getSupportingAccessPoint().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchMetricsEnabled() == null ? 0 : this.getCloudWatchMetricsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedFeatures() == null ? 0 : this.getAllowedFeatures().hashCode());
        hashCode = 31 * hashCode + (this.getTransformationConfigurations() == null ? 0 : this.getTransformationConfigurations().hashCode());
        return hashCode;
    }

    public ObjectLambdaConfiguration clone() {
        try {
            return (ObjectLambdaConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

