/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.s3control.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Specifies whether S3 on Outposts replicates delete markers. If you specify a <code>Filter</code> element in your
 * replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your
 * <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> element's
 * <code>Status</code> child element must be set to <code>Disabled</code>, because S3 on Outposts does not support
 * replicating delete markers for tag-based rules.
 * </p>
 * <p>
 * For more information about delete marker replication, see <a href=
 * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated"
 * >How delete operations affect replication</a> in the <i>Amazon S3 User Guide</i>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteMarkerReplication" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteMarkerReplication implements Serializable, Cloneable {

    /**
     * <p>
     * Indicates whether to replicate delete markers.
     * </p>
     */
    private String status;

    /**
     * <p>
     * Indicates whether to replicate delete markers.
     * </p>
     * 
     * @param status
     *        Indicates whether to replicate delete markers.
     * @see DeleteMarkerReplicationStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Indicates whether to replicate delete markers.
     * </p>
     * 
     * @return Indicates whether to replicate delete markers.
     * @see DeleteMarkerReplicationStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Indicates whether to replicate delete markers.
     * </p>
     * 
     * @param status
     *        Indicates whether to replicate delete markers.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DeleteMarkerReplicationStatus
     */

    public DeleteMarkerReplication withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Indicates whether to replicate delete markers.
     * </p>
     * 
     * @param status
     *        Indicates whether to replicate delete markers.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DeleteMarkerReplicationStatus
     */

    public DeleteMarkerReplication withStatus(DeleteMarkerReplicationStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteMarkerReplication == false)
            return false;
        DeleteMarkerReplication other = (DeleteMarkerReplication) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public DeleteMarkerReplication clone() {
        try {
            return (DeleteMarkerReplication) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
