/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.GetAccessGrantRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class GetAccessGrantRequestMarshaller
implements Marshaller<Request<GetAccessGrantRequest>, GetAccessGrantRequest> {
    public Request<GetAccessGrantRequest> marshall(GetAccessGrantRequest getAccessGrantRequest) {
        if (getAccessGrantRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getAccessGrantRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (getAccessGrantRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)getAccessGrantRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accessgrantsinstance/grant/{id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "id", getAccessGrantRequest.getAccessGrantId());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

