/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.ContainerDefinition;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateModelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String modelName;
    private ContainerDefinition primaryContainer;
    private List<ContainerDefinition> supplementalContainers;
    private String executionRoleArn;
    private List<Tag> tags;

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public CreateModelRequest withModelName(String modelName) {
        this.setModelName(modelName);
        return this;
    }

    public void setPrimaryContainer(ContainerDefinition primaryContainer) {
        this.primaryContainer = primaryContainer;
    }

    public ContainerDefinition getPrimaryContainer() {
        return this.primaryContainer;
    }

    public CreateModelRequest withPrimaryContainer(ContainerDefinition primaryContainer) {
        this.setPrimaryContainer(primaryContainer);
        return this;
    }

    public List<ContainerDefinition> getSupplementalContainers() {
        return this.supplementalContainers;
    }

    public void setSupplementalContainers(Collection<ContainerDefinition> supplementalContainers) {
        if (supplementalContainers == null) {
            this.supplementalContainers = null;
            return;
        }
        this.supplementalContainers = new ArrayList<ContainerDefinition>(supplementalContainers);
    }

    public CreateModelRequest withSupplementalContainers(ContainerDefinition ... supplementalContainers) {
        if (this.supplementalContainers == null) {
            this.setSupplementalContainers(new ArrayList<ContainerDefinition>(supplementalContainers.length));
        }
        for (ContainerDefinition ele : supplementalContainers) {
            this.supplementalContainers.add(ele);
        }
        return this;
    }

    public CreateModelRequest withSupplementalContainers(Collection<ContainerDefinition> supplementalContainers) {
        this.setSupplementalContainers(supplementalContainers);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public CreateModelRequest withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateModelRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateModelRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelName() != null) {
            sb.append("ModelName: ").append(this.getModelName()).append(",");
        }
        if (this.getPrimaryContainer() != null) {
            sb.append("PrimaryContainer: ").append(this.getPrimaryContainer()).append(",");
        }
        if (this.getSupplementalContainers() != null) {
            sb.append("SupplementalContainers: ").append(this.getSupplementalContainers()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest)obj;
        if (other.getModelName() == null ^ this.getModelName() == null) {
            return false;
        }
        if (other.getModelName() != null && !other.getModelName().equals(this.getModelName())) {
            return false;
        }
        if (other.getPrimaryContainer() == null ^ this.getPrimaryContainer() == null) {
            return false;
        }
        if (other.getPrimaryContainer() != null && !other.getPrimaryContainer().equals(this.getPrimaryContainer())) {
            return false;
        }
        if (other.getSupplementalContainers() == null ^ this.getSupplementalContainers() == null) {
            return false;
        }
        if (other.getSupplementalContainers() != null && !other.getSupplementalContainers().equals(this.getSupplementalContainers())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelName() == null ? 0 : this.getModelName().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryContainer() == null ? 0 : this.getPrimaryContainer().hashCode());
        hashCode = 31 * hashCode + (this.getSupplementalContainers() == null ? 0 : this.getSupplementalContainers().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateModelRequest clone() {
        return (CreateModelRequest)super.clone();
    }
}

