/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker;

import javax.annotation.Generated;

import com.amazonaws.services.sagemaker.model.*;
import com.amazonaws.*;
import com.amazonaws.services.sagemaker.waiters.AmazonSageMakerWaiters;

/**
 * Abstract implementation of {@code AmazonSageMaker}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonSageMaker implements AmazonSageMaker {

    protected AbstractAmazonSageMaker() {
    }

    @Override
    public AddTagsResult addTags(AddTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointResult createEndpoint(CreateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointConfigResult createEndpointConfig(CreateEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHyperParameterTuningJobResult createHyperParameterTuningJob(CreateHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNotebookInstanceResult createNotebookInstance(CreateNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNotebookInstanceLifecycleConfigResult createNotebookInstanceLifecycleConfig(CreateNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePresignedNotebookInstanceUrlResult createPresignedNotebookInstanceUrl(CreatePresignedNotebookInstanceUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrainingJobResult createTrainingJob(CreateTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTransformJobResult createTransformJob(CreateTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointResult deleteEndpoint(DeleteEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointConfigResult deleteEndpointConfig(DeleteEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelResult deleteModel(DeleteModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNotebookInstanceResult deleteNotebookInstance(DeleteNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNotebookInstanceLifecycleConfigResult deleteNotebookInstanceLifecycleConfig(DeleteNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointResult describeEndpoint(DescribeEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointConfigResult describeEndpointConfig(DescribeEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHyperParameterTuningJobResult describeHyperParameterTuningJob(DescribeHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelResult describeModel(DescribeModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNotebookInstanceResult describeNotebookInstance(DescribeNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNotebookInstanceLifecycleConfigResult describeNotebookInstanceLifecycleConfig(DescribeNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrainingJobResult describeTrainingJob(DescribeTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTransformJobResult describeTransformJob(DescribeTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointConfigsResult listEndpointConfigs(ListEndpointConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointsResult listEndpoints(ListEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHyperParameterTuningJobsResult listHyperParameterTuningJobs(ListHyperParameterTuningJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelsResult listModels(ListModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotebookInstanceLifecycleConfigsResult listNotebookInstanceLifecycleConfigs(ListNotebookInstanceLifecycleConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotebookInstancesResult listNotebookInstances(ListNotebookInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrainingJobsResult listTrainingJobs(ListTrainingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrainingJobsForHyperParameterTuningJobResult listTrainingJobsForHyperParameterTuningJob(ListTrainingJobsForHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTransformJobsResult listTransformJobs(ListTransformJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartNotebookInstanceResult startNotebookInstance(StartNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopHyperParameterTuningJobResult stopHyperParameterTuningJob(StopHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopNotebookInstanceResult stopNotebookInstance(StopNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTrainingJobResult stopTrainingJob(StopTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTransformJobResult stopTransformJob(StopTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointResult updateEndpoint(UpdateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointWeightsAndCapacitiesResult updateEndpointWeightsAndCapacities(UpdateEndpointWeightsAndCapacitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNotebookInstanceResult updateNotebookInstance(UpdateNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNotebookInstanceLifecycleConfigResult updateNotebookInstanceLifecycleConfig(UpdateNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AmazonSageMakerWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
