/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.TrainingJob;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class TrainingJobMarshaller {
    private static final MarshallingInfo<String> TRAININGJOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobName").build();
    private static final MarshallingInfo<String> TRAININGJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobArn").build();
    private static final MarshallingInfo<String> TUNINGJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TuningJobArn").build();
    private static final MarshallingInfo<String> LABELINGJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabelingJobArn").build();
    private static final MarshallingInfo<StructuredPojo> MODELARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelArtifacts").build();
    private static final MarshallingInfo<String> TRAININGJOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobStatus").build();
    private static final MarshallingInfo<String> SECONDARYSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecondaryStatus").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").build();
    private static final MarshallingInfo<Map> HYPERPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HyperParameters").build();
    private static final MarshallingInfo<StructuredPojo> ALGORITHMSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlgorithmSpecification").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<List> INPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceConfig").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").build();
    private static final MarshallingInfo<StructuredPojo> STOPPINGCONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StoppingCondition").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> TRAININGSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> TRAININGENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> SECONDARYSTATUSTRANSITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecondaryStatusTransitions").build();
    private static final MarshallingInfo<List> FINALMETRICDATALIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinalMetricDataList").build();
    private static final MarshallingInfo<Boolean> ENABLENETWORKISOLATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableNetworkIsolation").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final TrainingJobMarshaller instance = new TrainingJobMarshaller();

    public static TrainingJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(TrainingJob trainingJob, ProtocolMarshaller protocolMarshaller) {
        if (trainingJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)trainingJob.getTrainingJobName(), TRAININGJOBNAME_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getTrainingJobArn(), TRAININGJOBARN_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getTuningJobArn(), TUNINGJOBARN_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getLabelingJobArn(), LABELINGJOBARN_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getModelArtifacts(), MODELARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getTrainingJobStatus(), TRAININGJOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getSecondaryStatus(), SECONDARYSTATUS_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall(trainingJob.getHyperParameters(), HYPERPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getAlgorithmSpecification(), ALGORITHMSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(trainingJob.getInputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getOutputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getResourceConfig(), RESOURCECONFIG_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getVpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getStoppingCondition(), STOPPINGCONDITION_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getTrainingStartTime(), TRAININGSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getTrainingEndTime(), TRAININGENDTIME_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall(trainingJob.getSecondaryStatusTransitions(), SECONDARYSTATUSTRANSITIONS_BINDING);
            protocolMarshaller.marshall(trainingJob.getFinalMetricDataList(), FINALMETRICDATALIST_BINDING);
            protocolMarshaller.marshall((Object)trainingJob.getEnableNetworkIsolation(), ENABLENETWORKISOLATION_BINDING);
            protocolMarshaller.marshall(trainingJob.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

