/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ProcessingInput;

@SdkInternalApi
public class ProcessingInputMarshaller {
    private static final MarshallingInfo<String> INPUTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputName").build();
    private static final MarshallingInfo<StructuredPojo> S3INPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Input").build();
    private static final ProcessingInputMarshaller instance = new ProcessingInputMarshaller();

    public static ProcessingInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProcessingInput processingInput, ProtocolMarshaller protocolMarshaller) {
        if (processingInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)processingInput.getInputName(), INPUTNAME_BINDING);
            protocolMarshaller.marshall((Object)processingInput.getS3Input(), S3INPUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

