/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sagemaker.model.ImageVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListImageVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ImageVersion> imageVersions;
    private String nextToken;

    public List<ImageVersion> getImageVersions() {
        return this.imageVersions;
    }

    public void setImageVersions(Collection<ImageVersion> imageVersions) {
        if (imageVersions == null) {
            this.imageVersions = null;
            return;
        }
        this.imageVersions = new ArrayList<ImageVersion>(imageVersions);
    }

    public ListImageVersionsResult withImageVersions(ImageVersion ... imageVersions) {
        if (this.imageVersions == null) {
            this.setImageVersions(new ArrayList<ImageVersion>(imageVersions.length));
        }
        for (ImageVersion ele : imageVersions) {
            this.imageVersions.add(ele);
        }
        return this;
    }

    public ListImageVersionsResult withImageVersions(Collection<ImageVersion> imageVersions) {
        this.setImageVersions(imageVersions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListImageVersionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageVersions() != null) {
            sb.append("ImageVersions: ").append(this.getImageVersions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageVersionsResult)) {
            return false;
        }
        ListImageVersionsResult other = (ListImageVersionsResult)obj;
        if (other.getImageVersions() == null ^ this.getImageVersions() == null) {
            return false;
        }
        if (other.getImageVersions() != null && !other.getImageVersions().equals(this.getImageVersions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageVersions() == null ? 0 : this.getImageVersions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListImageVersionsResult clone() {
        try {
            return (ListImageVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

