/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.DeviceSummary;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DeviceSummaryMarshaller {
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").build();
    private static final MarshallingInfo<String> DEVICEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceArn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> DEVICEFLEETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceFleetName").build();
    private static final MarshallingInfo<String> IOTTHINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IotThingName").build();
    private static final MarshallingInfo<Date> REGISTRATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LATESTHEARTBEAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestHeartbeat").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> MODELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Models").build();
    private static final DeviceSummaryMarshaller instance = new DeviceSummaryMarshaller();

    public static DeviceSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeviceSummary deviceSummary, ProtocolMarshaller protocolMarshaller) {
        if (deviceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deviceSummary.getDeviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getDeviceArn(), DEVICEARN_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getDeviceFleetName(), DEVICEFLEETNAME_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getIotThingName(), IOTTHINGNAME_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getRegistrationTime(), REGISTRATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)deviceSummary.getLatestHeartbeat(), LATESTHEARTBEAT_BINDING);
            protocolMarshaller.marshall(deviceSummary.getModels(), MODELS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

