/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ArtifactSourceType;
import com.amazonaws.services.sagemaker.model.transform.ArtifactSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArtifactSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String sourceUri;
    private List<ArtifactSourceType> sourceTypes;

    public void setSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public ArtifactSource withSourceUri(String sourceUri) {
        this.setSourceUri(sourceUri);
        return this;
    }

    public List<ArtifactSourceType> getSourceTypes() {
        return this.sourceTypes;
    }

    public void setSourceTypes(Collection<ArtifactSourceType> sourceTypes) {
        if (sourceTypes == null) {
            this.sourceTypes = null;
            return;
        }
        this.sourceTypes = new ArrayList<ArtifactSourceType>(sourceTypes);
    }

    public ArtifactSource withSourceTypes(ArtifactSourceType ... sourceTypes) {
        if (this.sourceTypes == null) {
            this.setSourceTypes(new ArrayList<ArtifactSourceType>(sourceTypes.length));
        }
        for (ArtifactSourceType ele : sourceTypes) {
            this.sourceTypes.add(ele);
        }
        return this;
    }

    public ArtifactSource withSourceTypes(Collection<ArtifactSourceType> sourceTypes) {
        this.setSourceTypes(sourceTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceUri() != null) {
            sb.append("SourceUri: ").append(this.getSourceUri()).append(",");
        }
        if (this.getSourceTypes() != null) {
            sb.append("SourceTypes: ").append(this.getSourceTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactSource)) {
            return false;
        }
        ArtifactSource other = (ArtifactSource)obj;
        if (other.getSourceUri() == null ^ this.getSourceUri() == null) {
            return false;
        }
        if (other.getSourceUri() != null && !other.getSourceUri().equals(this.getSourceUri())) {
            return false;
        }
        if (other.getSourceTypes() == null ^ this.getSourceTypes() == null) {
            return false;
        }
        return other.getSourceTypes() == null || other.getSourceTypes().equals(this.getSourceTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceUri() == null ? 0 : this.getSourceUri().hashCode());
        hashCode = 31 * hashCode + (this.getSourceTypes() == null ? 0 : this.getSourceTypes().hashCode());
        return hashCode;
    }

    public ArtifactSource clone() {
        try {
            return (ArtifactSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

