/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.DeployedImage;
import com.amazonaws.services.sagemaker.model.ProductionVariantStatus;
import com.amazonaws.services.sagemaker.model.transform.ProductionVariantSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProductionVariantSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String variantName;
    private List<DeployedImage> deployedImages;
    private Float currentWeight;
    private Float desiredWeight;
    private Integer currentInstanceCount;
    private Integer desiredInstanceCount;
    private List<ProductionVariantStatus> variantStatus;

    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public ProductionVariantSummary withVariantName(String variantName) {
        this.setVariantName(variantName);
        return this;
    }

    public List<DeployedImage> getDeployedImages() {
        return this.deployedImages;
    }

    public void setDeployedImages(Collection<DeployedImage> deployedImages) {
        if (deployedImages == null) {
            this.deployedImages = null;
            return;
        }
        this.deployedImages = new ArrayList<DeployedImage>(deployedImages);
    }

    public ProductionVariantSummary withDeployedImages(DeployedImage ... deployedImages) {
        if (this.deployedImages == null) {
            this.setDeployedImages(new ArrayList<DeployedImage>(deployedImages.length));
        }
        for (DeployedImage ele : deployedImages) {
            this.deployedImages.add(ele);
        }
        return this;
    }

    public ProductionVariantSummary withDeployedImages(Collection<DeployedImage> deployedImages) {
        this.setDeployedImages(deployedImages);
        return this;
    }

    public void setCurrentWeight(Float currentWeight) {
        this.currentWeight = currentWeight;
    }

    public Float getCurrentWeight() {
        return this.currentWeight;
    }

    public ProductionVariantSummary withCurrentWeight(Float currentWeight) {
        this.setCurrentWeight(currentWeight);
        return this;
    }

    public void setDesiredWeight(Float desiredWeight) {
        this.desiredWeight = desiredWeight;
    }

    public Float getDesiredWeight() {
        return this.desiredWeight;
    }

    public ProductionVariantSummary withDesiredWeight(Float desiredWeight) {
        this.setDesiredWeight(desiredWeight);
        return this;
    }

    public void setCurrentInstanceCount(Integer currentInstanceCount) {
        this.currentInstanceCount = currentInstanceCount;
    }

    public Integer getCurrentInstanceCount() {
        return this.currentInstanceCount;
    }

    public ProductionVariantSummary withCurrentInstanceCount(Integer currentInstanceCount) {
        this.setCurrentInstanceCount(currentInstanceCount);
        return this;
    }

    public void setDesiredInstanceCount(Integer desiredInstanceCount) {
        this.desiredInstanceCount = desiredInstanceCount;
    }

    public Integer getDesiredInstanceCount() {
        return this.desiredInstanceCount;
    }

    public ProductionVariantSummary withDesiredInstanceCount(Integer desiredInstanceCount) {
        this.setDesiredInstanceCount(desiredInstanceCount);
        return this;
    }

    public List<ProductionVariantStatus> getVariantStatus() {
        return this.variantStatus;
    }

    public void setVariantStatus(Collection<ProductionVariantStatus> variantStatus) {
        if (variantStatus == null) {
            this.variantStatus = null;
            return;
        }
        this.variantStatus = new ArrayList<ProductionVariantStatus>(variantStatus);
    }

    public ProductionVariantSummary withVariantStatus(ProductionVariantStatus ... variantStatus) {
        if (this.variantStatus == null) {
            this.setVariantStatus(new ArrayList<ProductionVariantStatus>(variantStatus.length));
        }
        for (ProductionVariantStatus ele : variantStatus) {
            this.variantStatus.add(ele);
        }
        return this;
    }

    public ProductionVariantSummary withVariantStatus(Collection<ProductionVariantStatus> variantStatus) {
        this.setVariantStatus(variantStatus);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVariantName() != null) {
            sb.append("VariantName: ").append(this.getVariantName()).append(",");
        }
        if (this.getDeployedImages() != null) {
            sb.append("DeployedImages: ").append(this.getDeployedImages()).append(",");
        }
        if (this.getCurrentWeight() != null) {
            sb.append("CurrentWeight: ").append(this.getCurrentWeight()).append(",");
        }
        if (this.getDesiredWeight() != null) {
            sb.append("DesiredWeight: ").append(this.getDesiredWeight()).append(",");
        }
        if (this.getCurrentInstanceCount() != null) {
            sb.append("CurrentInstanceCount: ").append(this.getCurrentInstanceCount()).append(",");
        }
        if (this.getDesiredInstanceCount() != null) {
            sb.append("DesiredInstanceCount: ").append(this.getDesiredInstanceCount()).append(",");
        }
        if (this.getVariantStatus() != null) {
            sb.append("VariantStatus: ").append(this.getVariantStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantSummary)) {
            return false;
        }
        ProductionVariantSummary other = (ProductionVariantSummary)obj;
        if (other.getVariantName() == null ^ this.getVariantName() == null) {
            return false;
        }
        if (other.getVariantName() != null && !other.getVariantName().equals(this.getVariantName())) {
            return false;
        }
        if (other.getDeployedImages() == null ^ this.getDeployedImages() == null) {
            return false;
        }
        if (other.getDeployedImages() != null && !other.getDeployedImages().equals(this.getDeployedImages())) {
            return false;
        }
        if (other.getCurrentWeight() == null ^ this.getCurrentWeight() == null) {
            return false;
        }
        if (other.getCurrentWeight() != null && !other.getCurrentWeight().equals(this.getCurrentWeight())) {
            return false;
        }
        if (other.getDesiredWeight() == null ^ this.getDesiredWeight() == null) {
            return false;
        }
        if (other.getDesiredWeight() != null && !other.getDesiredWeight().equals(this.getDesiredWeight())) {
            return false;
        }
        if (other.getCurrentInstanceCount() == null ^ this.getCurrentInstanceCount() == null) {
            return false;
        }
        if (other.getCurrentInstanceCount() != null && !other.getCurrentInstanceCount().equals(this.getCurrentInstanceCount())) {
            return false;
        }
        if (other.getDesiredInstanceCount() == null ^ this.getDesiredInstanceCount() == null) {
            return false;
        }
        if (other.getDesiredInstanceCount() != null && !other.getDesiredInstanceCount().equals(this.getDesiredInstanceCount())) {
            return false;
        }
        if (other.getVariantStatus() == null ^ this.getVariantStatus() == null) {
            return false;
        }
        return other.getVariantStatus() == null || other.getVariantStatus().equals(this.getVariantStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVariantName() == null ? 0 : this.getVariantName().hashCode());
        hashCode = 31 * hashCode + (this.getDeployedImages() == null ? 0 : this.getDeployedImages().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentWeight() == null ? 0 : this.getCurrentWeight().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredWeight() == null ? 0 : this.getDesiredWeight().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentInstanceCount() == null ? 0 : this.getCurrentInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredInstanceCount() == null ? 0 : this.getDesiredInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getVariantStatus() == null ? 0 : this.getVariantStatus().hashCode());
        return hashCode;
    }

    public ProductionVariantSummary clone() {
        try {
            return (ProductionVariantSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProductionVariantSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

