/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.EndpointInputConfiguration;
import com.amazonaws.services.sagemaker.model.RecommendationJobResourceLimit;
import com.amazonaws.services.sagemaker.model.TrafficPattern;
import com.amazonaws.services.sagemaker.model.transform.RecommendationJobInputConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecommendationJobInputConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String modelPackageVersionArn;
    private Integer jobDurationInSeconds;
    private TrafficPattern trafficPattern;
    private RecommendationJobResourceLimit resourceLimit;
    private List<EndpointInputConfiguration> endpointConfigurations;

    public void setModelPackageVersionArn(String modelPackageVersionArn) {
        this.modelPackageVersionArn = modelPackageVersionArn;
    }

    public String getModelPackageVersionArn() {
        return this.modelPackageVersionArn;
    }

    public RecommendationJobInputConfig withModelPackageVersionArn(String modelPackageVersionArn) {
        this.setModelPackageVersionArn(modelPackageVersionArn);
        return this;
    }

    public void setJobDurationInSeconds(Integer jobDurationInSeconds) {
        this.jobDurationInSeconds = jobDurationInSeconds;
    }

    public Integer getJobDurationInSeconds() {
        return this.jobDurationInSeconds;
    }

    public RecommendationJobInputConfig withJobDurationInSeconds(Integer jobDurationInSeconds) {
        this.setJobDurationInSeconds(jobDurationInSeconds);
        return this;
    }

    public void setTrafficPattern(TrafficPattern trafficPattern) {
        this.trafficPattern = trafficPattern;
    }

    public TrafficPattern getTrafficPattern() {
        return this.trafficPattern;
    }

    public RecommendationJobInputConfig withTrafficPattern(TrafficPattern trafficPattern) {
        this.setTrafficPattern(trafficPattern);
        return this;
    }

    public void setResourceLimit(RecommendationJobResourceLimit resourceLimit) {
        this.resourceLimit = resourceLimit;
    }

    public RecommendationJobResourceLimit getResourceLimit() {
        return this.resourceLimit;
    }

    public RecommendationJobInputConfig withResourceLimit(RecommendationJobResourceLimit resourceLimit) {
        this.setResourceLimit(resourceLimit);
        return this;
    }

    public List<EndpointInputConfiguration> getEndpointConfigurations() {
        return this.endpointConfigurations;
    }

    public void setEndpointConfigurations(Collection<EndpointInputConfiguration> endpointConfigurations) {
        if (endpointConfigurations == null) {
            this.endpointConfigurations = null;
            return;
        }
        this.endpointConfigurations = new ArrayList<EndpointInputConfiguration>(endpointConfigurations);
    }

    public RecommendationJobInputConfig withEndpointConfigurations(EndpointInputConfiguration ... endpointConfigurations) {
        if (this.endpointConfigurations == null) {
            this.setEndpointConfigurations(new ArrayList<EndpointInputConfiguration>(endpointConfigurations.length));
        }
        for (EndpointInputConfiguration ele : endpointConfigurations) {
            this.endpointConfigurations.add(ele);
        }
        return this;
    }

    public RecommendationJobInputConfig withEndpointConfigurations(Collection<EndpointInputConfiguration> endpointConfigurations) {
        this.setEndpointConfigurations(endpointConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelPackageVersionArn() != null) {
            sb.append("ModelPackageVersionArn: ").append(this.getModelPackageVersionArn()).append(",");
        }
        if (this.getJobDurationInSeconds() != null) {
            sb.append("JobDurationInSeconds: ").append(this.getJobDurationInSeconds()).append(",");
        }
        if (this.getTrafficPattern() != null) {
            sb.append("TrafficPattern: ").append(this.getTrafficPattern()).append(",");
        }
        if (this.getResourceLimit() != null) {
            sb.append("ResourceLimit: ").append(this.getResourceLimit()).append(",");
        }
        if (this.getEndpointConfigurations() != null) {
            sb.append("EndpointConfigurations: ").append(this.getEndpointConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobInputConfig)) {
            return false;
        }
        RecommendationJobInputConfig other = (RecommendationJobInputConfig)obj;
        if (other.getModelPackageVersionArn() == null ^ this.getModelPackageVersionArn() == null) {
            return false;
        }
        if (other.getModelPackageVersionArn() != null && !other.getModelPackageVersionArn().equals(this.getModelPackageVersionArn())) {
            return false;
        }
        if (other.getJobDurationInSeconds() == null ^ this.getJobDurationInSeconds() == null) {
            return false;
        }
        if (other.getJobDurationInSeconds() != null && !other.getJobDurationInSeconds().equals(this.getJobDurationInSeconds())) {
            return false;
        }
        if (other.getTrafficPattern() == null ^ this.getTrafficPattern() == null) {
            return false;
        }
        if (other.getTrafficPattern() != null && !other.getTrafficPattern().equals(this.getTrafficPattern())) {
            return false;
        }
        if (other.getResourceLimit() == null ^ this.getResourceLimit() == null) {
            return false;
        }
        if (other.getResourceLimit() != null && !other.getResourceLimit().equals(this.getResourceLimit())) {
            return false;
        }
        if (other.getEndpointConfigurations() == null ^ this.getEndpointConfigurations() == null) {
            return false;
        }
        return other.getEndpointConfigurations() == null || other.getEndpointConfigurations().equals(this.getEndpointConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelPackageVersionArn() == null ? 0 : this.getModelPackageVersionArn().hashCode());
        hashCode = 31 * hashCode + (this.getJobDurationInSeconds() == null ? 0 : this.getJobDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficPattern() == null ? 0 : this.getTrafficPattern().hashCode());
        hashCode = 31 * hashCode + (this.getResourceLimit() == null ? 0 : this.getResourceLimit().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointConfigurations() == null ? 0 : this.getEndpointConfigurations().hashCode());
        return hashCode;
    }

    public RecommendationJobInputConfig clone() {
        try {
            return (RecommendationJobInputConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationJobInputConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

