/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Configuration for uploading output from the processing container.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ProcessingOutputConfig" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ProcessingOutputConfig implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An array of outputs configuring the data to upload from the processing container.
     * </p>
     */
    private java.util.List<ProcessingOutput> outputs;
    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a
     * KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     * </p>
     */
    private String kmsKeyId;

    /**
     * <p>
     * An array of outputs configuring the data to upload from the processing container.
     * </p>
     * 
     * @return An array of outputs configuring the data to upload from the processing container.
     */

    public java.util.List<ProcessingOutput> getOutputs() {
        return outputs;
    }

    /**
     * <p>
     * An array of outputs configuring the data to upload from the processing container.
     * </p>
     * 
     * @param outputs
     *        An array of outputs configuring the data to upload from the processing container.
     */

    public void setOutputs(java.util.Collection<ProcessingOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }

        this.outputs = new java.util.ArrayList<ProcessingOutput>(outputs);
    }

    /**
     * <p>
     * An array of outputs configuring the data to upload from the processing container.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setOutputs(java.util.Collection)} or {@link #withOutputs(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param outputs
     *        An array of outputs configuring the data to upload from the processing container.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProcessingOutputConfig withOutputs(ProcessingOutput... outputs) {
        if (this.outputs == null) {
            setOutputs(new java.util.ArrayList<ProcessingOutput>(outputs.length));
        }
        for (ProcessingOutput ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of outputs configuring the data to upload from the processing container.
     * </p>
     * 
     * @param outputs
     *        An array of outputs configuring the data to upload from the processing container.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProcessingOutputConfig withOutputs(java.util.Collection<ProcessingOutput> outputs) {
        setOutputs(outputs);
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a
     * KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     * </p>
     * 
     * @param kmsKeyId
     *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     *        encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key,
     *        alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     */

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a
     * KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses
     *         to encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key,
     *         alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     */

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a
     * KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     * </p>
     * 
     * @param kmsKeyId
     *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     *        encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key,
     *        alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProcessingOutputConfig withKmsKeyId(String kmsKeyId) {
        setKmsKeyId(kmsKeyId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOutputs() != null)
            sb.append("Outputs: ").append(getOutputs()).append(",");
        if (getKmsKeyId() != null)
            sb.append("KmsKeyId: ").append(getKmsKeyId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ProcessingOutputConfig == false)
            return false;
        ProcessingOutputConfig other = (ProcessingOutputConfig) obj;
        if (other.getOutputs() == null ^ this.getOutputs() == null)
            return false;
        if (other.getOutputs() != null && other.getOutputs().equals(this.getOutputs()) == false)
            return false;
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null)
            return false;
        if (other.getKmsKeyId() != null && other.getKmsKeyId().equals(this.getKmsKeyId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOutputs() == null) ? 0 : getOutputs().hashCode());
        hashCode = prime * hashCode + ((getKmsKeyId() == null) ? 0 : getKmsKeyId().hashCode());
        return hashCode;
    }

    @Override
    public ProcessingOutputConfig clone() {
        try {
            return (ProcessingOutputConfig) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemaker.model.transform.ProcessingOutputConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
