/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ProcessingS3Output;

@SdkInternalApi
public class ProcessingS3OutputMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final MarshallingInfo<String> LOCALPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalPath").build();
    private static final MarshallingInfo<String> S3UPLOADMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3UploadMode").build();
    private static final ProcessingS3OutputMarshaller instance = new ProcessingS3OutputMarshaller();

    public static ProcessingS3OutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProcessingS3Output processingS3Output, ProtocolMarshaller protocolMarshaller) {
        if (processingS3Output == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)processingS3Output.getS3Uri(), S3URI_BINDING);
            protocolMarshaller.marshall((Object)processingS3Output.getLocalPath(), LOCALPATH_BINDING);
            protocolMarshaller.marshall((Object)processingS3Output.getS3UploadMode(), S3UPLOADMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

