/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The model registry settings for the SageMaker Canvas application.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ModelRegisterSettings" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ModelRegisterSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * </p>
     */
    private String status;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions
     * created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services account in which
     * SageMaker model registry is set up.
     * </p>
     */
    private String crossAccountModelRegisterRoleArn;

    /**
     * <p>
     * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * </p>
     * 
     * @param status
     *        Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * </p>
     * 
     * @return Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * </p>
     * 
     * @param status
     *        Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FeatureStatus
     */

    public ModelRegisterSettings withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * </p>
     * 
     * @param status
     *        Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FeatureStatus
     */

    public ModelRegisterSettings withStatus(FeatureStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions
     * created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services account in which
     * SageMaker model registry is set up.
     * </p>
     * 
     * @param crossAccountModelRegisterRoleArn
     *        The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model
     *        versions created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services
     *        account in which SageMaker model registry is set up.
     */

    public void setCrossAccountModelRegisterRoleArn(String crossAccountModelRegisterRoleArn) {
        this.crossAccountModelRegisterRoleArn = crossAccountModelRegisterRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions
     * created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services account in which
     * SageMaker model registry is set up.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model
     *         versions created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services
     *         account in which SageMaker model registry is set up.
     */

    public String getCrossAccountModelRegisterRoleArn() {
        return this.crossAccountModelRegisterRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions
     * created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services account in which
     * SageMaker model registry is set up.
     * </p>
     * 
     * @param crossAccountModelRegisterRoleArn
     *        The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model
     *        versions created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services
     *        account in which SageMaker model registry is set up.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ModelRegisterSettings withCrossAccountModelRegisterRoleArn(String crossAccountModelRegisterRoleArn) {
        setCrossAccountModelRegisterRoleArn(crossAccountModelRegisterRoleArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getCrossAccountModelRegisterRoleArn() != null)
            sb.append("CrossAccountModelRegisterRoleArn: ").append(getCrossAccountModelRegisterRoleArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ModelRegisterSettings == false)
            return false;
        ModelRegisterSettings other = (ModelRegisterSettings) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getCrossAccountModelRegisterRoleArn() == null ^ this.getCrossAccountModelRegisterRoleArn() == null)
            return false;
        if (other.getCrossAccountModelRegisterRoleArn() != null
                && other.getCrossAccountModelRegisterRoleArn().equals(this.getCrossAccountModelRegisterRoleArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getCrossAccountModelRegisterRoleArn() == null) ? 0 : getCrossAccountModelRegisterRoleArn().hashCode());
        return hashCode;
    }

    @Override
    public ModelRegisterSettings clone() {
        try {
            return (ModelRegisterSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemaker.model.transform.ModelRegisterSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
