/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.sagemaker.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PipelineExecutionStep JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PipelineExecutionStepJsonUnmarshaller implements Unmarshaller<PipelineExecutionStep, JsonUnmarshallerContext> {

    public PipelineExecutionStep unmarshall(JsonUnmarshallerContext context) throws Exception {
        PipelineExecutionStep pipelineExecutionStep = new PipelineExecutionStep();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StepName", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setStepName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StepDisplayName", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setStepDisplayName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StepDescription", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setStepDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StartTime", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setStartTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("EndTime", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setEndTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("StepStatus", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setStepStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CacheHitResult", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setCacheHitResult(CacheHitResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AttemptCount", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setAttemptCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("FailureReason", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setFailureReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Metadata", targetDepth)) {
                    context.nextToken();
                    pipelineExecutionStep.setMetadata(PipelineExecutionStepMetadataJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return pipelineExecutionStep;
    }

    private static PipelineExecutionStepJsonUnmarshaller instance;

    public static PipelineExecutionStepJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new PipelineExecutionStepJsonUnmarshaller();
        return instance;
    }
}
