/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.sagemaker.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PipelineExecution JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PipelineExecutionJsonUnmarshaller implements Unmarshaller<PipelineExecution, JsonUnmarshallerContext> {

    public PipelineExecution unmarshall(JsonUnmarshallerContext context) throws Exception {
        PipelineExecution pipelineExecution = new PipelineExecution();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("PipelineArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setPipelineArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PipelineExecutionArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setPipelineExecutionArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PipelineExecutionDisplayName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setPipelineExecutionDisplayName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PipelineExecutionStatus", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setPipelineExecutionStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PipelineExecutionDescription", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setPipelineExecutionDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PipelineExperimentConfig", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setPipelineExperimentConfig(PipelineExperimentConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("FailureReason", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setFailureReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setCreationTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setLastModifiedTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("CreatedBy", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setCreatedBy(UserContextJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LastModifiedBy", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setLastModifiedBy(UserContextJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ParallelismConfiguration", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setParallelismConfiguration(ParallelismConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PipelineParameters", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setPipelineParameters(new ListUnmarshaller<Parameter>(ParameterJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("SelectiveExecutionConfig", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    pipelineExecution.setSelectiveExecutionConfig(SelectiveExecutionConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return pipelineExecution;
    }

    private static PipelineExecutionJsonUnmarshaller instance;

    public static PipelineExecutionJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new PipelineExecutionJsonUnmarshaller();
        return instance;
    }
}
