/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.sagemaker.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TimeSeriesForecastingJobConfig JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TimeSeriesForecastingJobConfigJsonUnmarshaller implements Unmarshaller<TimeSeriesForecastingJobConfig, JsonUnmarshallerContext> {

    public TimeSeriesForecastingJobConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig = new TimeSeriesForecastingJobConfig();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("FeatureSpecificationS3Uri", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    timeSeriesForecastingJobConfig.setFeatureSpecificationS3Uri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CompletionCriteria", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    timeSeriesForecastingJobConfig.setCompletionCriteria(AutoMLJobCompletionCriteriaJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ForecastFrequency", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    timeSeriesForecastingJobConfig.setForecastFrequency(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ForecastHorizon", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    timeSeriesForecastingJobConfig.setForecastHorizon(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ForecastQuantiles", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    timeSeriesForecastingJobConfig.setForecastQuantiles(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("Transformations", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    timeSeriesForecastingJobConfig.setTransformations(TimeSeriesTransformationsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TimeSeriesConfig", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    timeSeriesForecastingJobConfig.setTimeSeriesConfig(TimeSeriesConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("HolidayConfig", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    timeSeriesForecastingJobConfig.setHolidayConfig(new ListUnmarshaller<HolidayConfigAttributes>(HolidayConfigAttributesJsonUnmarshaller
                            .getInstance())

                    .unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return timeSeriesForecastingJobConfig;
    }

    private static TimeSeriesForecastingJobConfigJsonUnmarshaller instance;

    public static TimeSeriesForecastingJobConfigJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new TimeSeriesForecastingJobConfigJsonUnmarshaller();
        return instance;
    }
}
