/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.Framework;
import com.amazonaws.services.sagemaker.model.transform.InputConfigMarshaller;
import java.io.Serializable;

public class InputConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Uri;
    private String dataInputConfig;
    private String framework;
    private String frameworkVersion;

    public void setS3Uri(String s3Uri) {
        this.s3Uri = s3Uri;
    }

    public String getS3Uri() {
        return this.s3Uri;
    }

    public InputConfig withS3Uri(String s3Uri) {
        this.setS3Uri(s3Uri);
        return this;
    }

    public void setDataInputConfig(String dataInputConfig) {
        this.dataInputConfig = dataInputConfig;
    }

    public String getDataInputConfig() {
        return this.dataInputConfig;
    }

    public InputConfig withDataInputConfig(String dataInputConfig) {
        this.setDataInputConfig(dataInputConfig);
        return this;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public String getFramework() {
        return this.framework;
    }

    public InputConfig withFramework(String framework) {
        this.setFramework(framework);
        return this;
    }

    public InputConfig withFramework(Framework framework) {
        this.framework = framework.toString();
        return this;
    }

    public void setFrameworkVersion(String frameworkVersion) {
        this.frameworkVersion = frameworkVersion;
    }

    public String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public InputConfig withFrameworkVersion(String frameworkVersion) {
        this.setFrameworkVersion(frameworkVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Uri() != null) {
            sb.append("S3Uri: ").append(this.getS3Uri()).append(",");
        }
        if (this.getDataInputConfig() != null) {
            sb.append("DataInputConfig: ").append(this.getDataInputConfig()).append(",");
        }
        if (this.getFramework() != null) {
            sb.append("Framework: ").append(this.getFramework()).append(",");
        }
        if (this.getFrameworkVersion() != null) {
            sb.append("FrameworkVersion: ").append(this.getFrameworkVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfig)) {
            return false;
        }
        InputConfig other = (InputConfig)obj;
        if (other.getS3Uri() == null ^ this.getS3Uri() == null) {
            return false;
        }
        if (other.getS3Uri() != null && !other.getS3Uri().equals(this.getS3Uri())) {
            return false;
        }
        if (other.getDataInputConfig() == null ^ this.getDataInputConfig() == null) {
            return false;
        }
        if (other.getDataInputConfig() != null && !other.getDataInputConfig().equals(this.getDataInputConfig())) {
            return false;
        }
        if (other.getFramework() == null ^ this.getFramework() == null) {
            return false;
        }
        if (other.getFramework() != null && !other.getFramework().equals(this.getFramework())) {
            return false;
        }
        if (other.getFrameworkVersion() == null ^ this.getFrameworkVersion() == null) {
            return false;
        }
        return other.getFrameworkVersion() == null || other.getFrameworkVersion().equals(this.getFrameworkVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Uri() == null ? 0 : this.getS3Uri().hashCode());
        hashCode = 31 * hashCode + (this.getDataInputConfig() == null ? 0 : this.getDataInputConfig().hashCode());
        hashCode = 31 * hashCode + (this.getFramework() == null ? 0 : this.getFramework().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworkVersion() == null ? 0 : this.getFrameworkVersion().hashCode());
        return hashCode;
    }

    public InputConfig clone() {
        try {
            return (InputConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

