/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.InferenceComponentContainerSpecificationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class InferenceComponentContainerSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String image;
    private String artifactUrl;
    private Map<String, String> environment;

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public InferenceComponentContainerSpecification withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public String getArtifactUrl() {
        return this.artifactUrl;
    }

    public InferenceComponentContainerSpecification withArtifactUrl(String artifactUrl) {
        this.setArtifactUrl(artifactUrl);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public InferenceComponentContainerSpecification withEnvironment(Map<String, String> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public InferenceComponentContainerSpecification addEnvironmentEntry(String key, String value) {
        if (null == this.environment) {
            this.environment = new HashMap<String, String>();
        }
        if (this.environment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environment.put(key, value);
        return this;
    }

    public InferenceComponentContainerSpecification clearEnvironmentEntries() {
        this.environment = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getArtifactUrl() != null) {
            sb.append("ArtifactUrl: ").append(this.getArtifactUrl()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentContainerSpecification)) {
            return false;
        }
        InferenceComponentContainerSpecification other = (InferenceComponentContainerSpecification)obj;
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getArtifactUrl() == null ^ this.getArtifactUrl() == null) {
            return false;
        }
        if (other.getArtifactUrl() != null && !other.getArtifactUrl().equals(this.getArtifactUrl())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactUrl() == null ? 0 : this.getArtifactUrl().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public InferenceComponentContainerSpecification clone() {
        try {
            return (InferenceComponentContainerSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InferenceComponentContainerSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

