/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.sagemaker.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AppImageConfigDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AppImageConfigDetailsMarshaller {

    private static final MarshallingInfo<String> APPIMAGECONFIGARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppImageConfigArn").build();
    private static final MarshallingInfo<String> APPIMAGECONFIGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppImageConfigName").build();
    private static final MarshallingInfo<java.util.Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<java.util.Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> KERNELGATEWAYIMAGECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KernelGatewayImageConfig").build();
    private static final MarshallingInfo<StructuredPojo> JUPYTERLABAPPIMAGECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JupyterLabAppImageConfig").build();
    private static final MarshallingInfo<StructuredPojo> CODEEDITORAPPIMAGECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeEditorAppImageConfig").build();

    private static final AppImageConfigDetailsMarshaller instance = new AppImageConfigDetailsMarshaller();

    public static AppImageConfigDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AppImageConfigDetails appImageConfigDetails, ProtocolMarshaller protocolMarshaller) {

        if (appImageConfigDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(appImageConfigDetails.getAppImageConfigArn(), APPIMAGECONFIGARN_BINDING);
            protocolMarshaller.marshall(appImageConfigDetails.getAppImageConfigName(), APPIMAGECONFIGNAME_BINDING);
            protocolMarshaller.marshall(appImageConfigDetails.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(appImageConfigDetails.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall(appImageConfigDetails.getKernelGatewayImageConfig(), KERNELGATEWAYIMAGECONFIG_BINDING);
            protocolMarshaller.marshall(appImageConfigDetails.getJupyterLabAppImageConfig(), JUPYTERLABAPPIMAGECONFIG_BINDING);
            protocolMarshaller.marshall(appImageConfigDetails.getCodeEditorAppImageConfig(), CODEEDITORAPPIMAGECONFIG_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
