/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker;

import javax.annotation.Generated;

import com.amazonaws.services.sagemaker.model.*;
import com.amazonaws.*;
import com.amazonaws.services.sagemaker.waiters.AmazonSageMakerWaiters;

/**
 * Abstract implementation of {@code AmazonSageMaker}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonSageMaker implements AmazonSageMaker {

    protected AbstractAmazonSageMaker() {
    }

    @Override
    public AddAssociationResult addAssociation(AddAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddTagsResult addTags(AddTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateTrialComponentResult associateTrialComponent(AssociateTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDescribeModelPackageResult batchDescribeModelPackage(BatchDescribeModelPackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateActionResult createAction(CreateActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAlgorithmResult createAlgorithm(CreateAlgorithmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppResult createApp(CreateAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppImageConfigResult createAppImageConfig(CreateAppImageConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateArtifactResult createArtifact(CreateArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAutoMLJobResult createAutoMLJob(CreateAutoMLJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAutoMLJobV2Result createAutoMLJobV2(CreateAutoMLJobV2Request request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateClusterResult createCluster(CreateClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCodeRepositoryResult createCodeRepository(CreateCodeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCompilationJobResult createCompilationJob(CreateCompilationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateContextResult createContext(CreateContextRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataQualityJobDefinitionResult createDataQualityJobDefinition(CreateDataQualityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeviceFleetResult createDeviceFleet(CreateDeviceFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEdgeDeploymentPlanResult createEdgeDeploymentPlan(CreateEdgeDeploymentPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEdgeDeploymentStageResult createEdgeDeploymentStage(CreateEdgeDeploymentStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEdgePackagingJobResult createEdgePackagingJob(CreateEdgePackagingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointResult createEndpoint(CreateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointConfigResult createEndpointConfig(CreateEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateExperimentResult createExperiment(CreateExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFeatureGroupResult createFeatureGroup(CreateFeatureGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFlowDefinitionResult createFlowDefinition(CreateFlowDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHubResult createHub(CreateHubRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHubContentReferenceResult createHubContentReference(CreateHubContentReferenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHumanTaskUiResult createHumanTaskUi(CreateHumanTaskUiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHyperParameterTuningJobResult createHyperParameterTuningJob(CreateHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateImageResult createImage(CreateImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateImageVersionResult createImageVersion(CreateImageVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInferenceComponentResult createInferenceComponent(CreateInferenceComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInferenceExperimentResult createInferenceExperiment(CreateInferenceExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInferenceRecommendationsJobResult createInferenceRecommendationsJob(CreateInferenceRecommendationsJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLabelingJobResult createLabelingJob(CreateLabelingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMlflowTrackingServerResult createMlflowTrackingServer(CreateMlflowTrackingServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelBiasJobDefinitionResult createModelBiasJobDefinition(CreateModelBiasJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelCardResult createModelCard(CreateModelCardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelCardExportJobResult createModelCardExportJob(CreateModelCardExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelExplainabilityJobDefinitionResult createModelExplainabilityJobDefinition(CreateModelExplainabilityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelPackageResult createModelPackage(CreateModelPackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelPackageGroupResult createModelPackageGroup(CreateModelPackageGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelQualityJobDefinitionResult createModelQualityJobDefinition(CreateModelQualityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMonitoringScheduleResult createMonitoringSchedule(CreateMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNotebookInstanceResult createNotebookInstance(CreateNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNotebookInstanceLifecycleConfigResult createNotebookInstanceLifecycleConfig(CreateNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePresignedDomainUrlResult createPresignedDomainUrl(CreatePresignedDomainUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePresignedMlflowTrackingServerUrlResult createPresignedMlflowTrackingServerUrl(CreatePresignedMlflowTrackingServerUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePresignedNotebookInstanceUrlResult createPresignedNotebookInstanceUrl(CreatePresignedNotebookInstanceUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProcessingJobResult createProcessingJob(CreateProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSpaceResult createSpace(CreateSpaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStudioLifecycleConfigResult createStudioLifecycleConfig(CreateStudioLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrainingJobResult createTrainingJob(CreateTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTransformJobResult createTransformJob(CreateTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrialResult createTrial(CreateTrialRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrialComponentResult createTrialComponent(CreateTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserProfileResult createUserProfile(CreateUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkforceResult createWorkforce(CreateWorkforceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkteamResult createWorkteam(CreateWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteActionResult deleteAction(DeleteActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAlgorithmResult deleteAlgorithm(DeleteAlgorithmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppResult deleteApp(DeleteAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppImageConfigResult deleteAppImageConfig(DeleteAppImageConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteArtifactResult deleteArtifact(DeleteArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssociationResult deleteAssociation(DeleteAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCodeRepositoryResult deleteCodeRepository(DeleteCodeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCompilationJobResult deleteCompilationJob(DeleteCompilationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteContextResult deleteContext(DeleteContextRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataQualityJobDefinitionResult deleteDataQualityJobDefinition(DeleteDataQualityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeviceFleetResult deleteDeviceFleet(DeleteDeviceFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEdgeDeploymentPlanResult deleteEdgeDeploymentPlan(DeleteEdgeDeploymentPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEdgeDeploymentStageResult deleteEdgeDeploymentStage(DeleteEdgeDeploymentStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointResult deleteEndpoint(DeleteEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointConfigResult deleteEndpointConfig(DeleteEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteExperimentResult deleteExperiment(DeleteExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFeatureGroupResult deleteFeatureGroup(DeleteFeatureGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFlowDefinitionResult deleteFlowDefinition(DeleteFlowDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteHubResult deleteHub(DeleteHubRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteHubContentResult deleteHubContent(DeleteHubContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteHubContentReferenceResult deleteHubContentReference(DeleteHubContentReferenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteHumanTaskUiResult deleteHumanTaskUi(DeleteHumanTaskUiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteHyperParameterTuningJobResult deleteHyperParameterTuningJob(DeleteHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteImageResult deleteImage(DeleteImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteImageVersionResult deleteImageVersion(DeleteImageVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInferenceComponentResult deleteInferenceComponent(DeleteInferenceComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInferenceExperimentResult deleteInferenceExperiment(DeleteInferenceExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMlflowTrackingServerResult deleteMlflowTrackingServer(DeleteMlflowTrackingServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelResult deleteModel(DeleteModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelBiasJobDefinitionResult deleteModelBiasJobDefinition(DeleteModelBiasJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelCardResult deleteModelCard(DeleteModelCardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelExplainabilityJobDefinitionResult deleteModelExplainabilityJobDefinition(DeleteModelExplainabilityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelPackageResult deleteModelPackage(DeleteModelPackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelPackageGroupResult deleteModelPackageGroup(DeleteModelPackageGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelPackageGroupPolicyResult deleteModelPackageGroupPolicy(DeleteModelPackageGroupPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelQualityJobDefinitionResult deleteModelQualityJobDefinition(DeleteModelQualityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMonitoringScheduleResult deleteMonitoringSchedule(DeleteMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNotebookInstanceResult deleteNotebookInstance(DeleteNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNotebookInstanceLifecycleConfigResult deleteNotebookInstanceLifecycleConfig(DeleteNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSpaceResult deleteSpace(DeleteSpaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteStudioLifecycleConfigResult deleteStudioLifecycleConfig(DeleteStudioLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrialResult deleteTrial(DeleteTrialRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrialComponentResult deleteTrialComponent(DeleteTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserProfileResult deleteUserProfile(DeleteUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkforceResult deleteWorkforce(DeleteWorkforceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkteamResult deleteWorkteam(DeleteWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterDevicesResult deregisterDevices(DeregisterDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeActionResult describeAction(DescribeActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAlgorithmResult describeAlgorithm(DescribeAlgorithmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppResult describeApp(DescribeAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppImageConfigResult describeAppImageConfig(DescribeAppImageConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeArtifactResult describeArtifact(DescribeArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAutoMLJobResult describeAutoMLJob(DescribeAutoMLJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAutoMLJobV2Result describeAutoMLJobV2(DescribeAutoMLJobV2Request request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClusterResult describeCluster(DescribeClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClusterNodeResult describeClusterNode(DescribeClusterNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCodeRepositoryResult describeCodeRepository(DescribeCodeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCompilationJobResult describeCompilationJob(DescribeCompilationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeContextResult describeContext(DescribeContextRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataQualityJobDefinitionResult describeDataQualityJobDefinition(DescribeDataQualityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDeviceResult describeDevice(DescribeDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDeviceFleetResult describeDeviceFleet(DescribeDeviceFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDomainResult describeDomain(DescribeDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEdgeDeploymentPlanResult describeEdgeDeploymentPlan(DescribeEdgeDeploymentPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEdgePackagingJobResult describeEdgePackagingJob(DescribeEdgePackagingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointResult describeEndpoint(DescribeEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointConfigResult describeEndpointConfig(DescribeEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeExperimentResult describeExperiment(DescribeExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFeatureGroupResult describeFeatureGroup(DescribeFeatureGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFeatureMetadataResult describeFeatureMetadata(DescribeFeatureMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFlowDefinitionResult describeFlowDefinition(DescribeFlowDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHubResult describeHub(DescribeHubRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHubContentResult describeHubContent(DescribeHubContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHumanTaskUiResult describeHumanTaskUi(DescribeHumanTaskUiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHyperParameterTuningJobResult describeHyperParameterTuningJob(DescribeHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeImageResult describeImage(DescribeImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeImageVersionResult describeImageVersion(DescribeImageVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInferenceComponentResult describeInferenceComponent(DescribeInferenceComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInferenceExperimentResult describeInferenceExperiment(DescribeInferenceExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInferenceRecommendationsJobResult describeInferenceRecommendationsJob(DescribeInferenceRecommendationsJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLabelingJobResult describeLabelingJob(DescribeLabelingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLineageGroupResult describeLineageGroup(DescribeLineageGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMlflowTrackingServerResult describeMlflowTrackingServer(DescribeMlflowTrackingServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelResult describeModel(DescribeModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelBiasJobDefinitionResult describeModelBiasJobDefinition(DescribeModelBiasJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelCardResult describeModelCard(DescribeModelCardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelCardExportJobResult describeModelCardExportJob(DescribeModelCardExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelExplainabilityJobDefinitionResult describeModelExplainabilityJobDefinition(DescribeModelExplainabilityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelPackageResult describeModelPackage(DescribeModelPackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelPackageGroupResult describeModelPackageGroup(DescribeModelPackageGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelQualityJobDefinitionResult describeModelQualityJobDefinition(DescribeModelQualityJobDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMonitoringScheduleResult describeMonitoringSchedule(DescribeMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNotebookInstanceResult describeNotebookInstance(DescribeNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNotebookInstanceLifecycleConfigResult describeNotebookInstanceLifecycleConfig(DescribeNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePipelineResult describePipeline(DescribePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePipelineDefinitionForExecutionResult describePipelineDefinitionForExecution(DescribePipelineDefinitionForExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePipelineExecutionResult describePipelineExecution(DescribePipelineExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProcessingJobResult describeProcessingJob(DescribeProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProjectResult describeProject(DescribeProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSpaceResult describeSpace(DescribeSpaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeStudioLifecycleConfigResult describeStudioLifecycleConfig(DescribeStudioLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSubscribedWorkteamResult describeSubscribedWorkteam(DescribeSubscribedWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrainingJobResult describeTrainingJob(DescribeTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTransformJobResult describeTransformJob(DescribeTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrialResult describeTrial(DescribeTrialRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrialComponentResult describeTrialComponent(DescribeTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeUserProfileResult describeUserProfile(DescribeUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkforceResult describeWorkforce(DescribeWorkforceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkteamResult describeWorkteam(DescribeWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableSagemakerServicecatalogPortfolioResult disableSagemakerServicecatalogPortfolio(DisableSagemakerServicecatalogPortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateTrialComponentResult disassociateTrialComponent(DisassociateTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableSagemakerServicecatalogPortfolioResult enableSagemakerServicecatalogPortfolio(EnableSagemakerServicecatalogPortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceFleetReportResult getDeviceFleetReport(GetDeviceFleetReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLineageGroupPolicyResult getLineageGroupPolicy(GetLineageGroupPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelPackageGroupPolicyResult getModelPackageGroupPolicy(GetModelPackageGroupPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSagemakerServicecatalogPortfolioStatusResult getSagemakerServicecatalogPortfolioStatus(GetSagemakerServicecatalogPortfolioStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetScalingConfigurationRecommendationResult getScalingConfigurationRecommendation(GetScalingConfigurationRecommendationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSearchSuggestionsResult getSearchSuggestions(GetSearchSuggestionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportHubContentResult importHubContent(ImportHubContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListActionsResult listActions(ListActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAlgorithmsResult listAlgorithms(ListAlgorithmsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAliasesResult listAliases(ListAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppImageConfigsResult listAppImageConfigs(ListAppImageConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppsResult listApps(ListAppsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListArtifactsResult listArtifacts(ListArtifactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssociationsResult listAssociations(ListAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAutoMLJobsResult listAutoMLJobs(ListAutoMLJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCandidatesForAutoMLJobResult listCandidatesForAutoMLJob(ListCandidatesForAutoMLJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClusterNodesResult listClusterNodes(ListClusterNodesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClustersResult listClusters(ListClustersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCodeRepositoriesResult listCodeRepositories(ListCodeRepositoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCompilationJobsResult listCompilationJobs(ListCompilationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListContextsResult listContexts(ListContextsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataQualityJobDefinitionsResult listDataQualityJobDefinitions(ListDataQualityJobDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeviceFleetsResult listDeviceFleets(ListDeviceFleetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDevicesResult listDevices(ListDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEdgeDeploymentPlansResult listEdgeDeploymentPlans(ListEdgeDeploymentPlansRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEdgePackagingJobsResult listEdgePackagingJobs(ListEdgePackagingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointConfigsResult listEndpointConfigs(ListEndpointConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointsResult listEndpoints(ListEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExperimentsResult listExperiments(ListExperimentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFeatureGroupsResult listFeatureGroups(ListFeatureGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlowDefinitionsResult listFlowDefinitions(ListFlowDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHubContentVersionsResult listHubContentVersions(ListHubContentVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHubContentsResult listHubContents(ListHubContentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHubsResult listHubs(ListHubsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHumanTaskUisResult listHumanTaskUis(ListHumanTaskUisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHyperParameterTuningJobsResult listHyperParameterTuningJobs(ListHyperParameterTuningJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImageVersionsResult listImageVersions(ListImageVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImagesResult listImages(ListImagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInferenceComponentsResult listInferenceComponents(ListInferenceComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInferenceExperimentsResult listInferenceExperiments(ListInferenceExperimentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInferenceRecommendationsJobStepsResult listInferenceRecommendationsJobSteps(ListInferenceRecommendationsJobStepsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInferenceRecommendationsJobsResult listInferenceRecommendationsJobs(ListInferenceRecommendationsJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLabelingJobsResult listLabelingJobs(ListLabelingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLabelingJobsForWorkteamResult listLabelingJobsForWorkteam(ListLabelingJobsForWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLineageGroupsResult listLineageGroups(ListLineageGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMlflowTrackingServersResult listMlflowTrackingServers(ListMlflowTrackingServersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelBiasJobDefinitionsResult listModelBiasJobDefinitions(ListModelBiasJobDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelCardExportJobsResult listModelCardExportJobs(ListModelCardExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelCardVersionsResult listModelCardVersions(ListModelCardVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelCardsResult listModelCards(ListModelCardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelExplainabilityJobDefinitionsResult listModelExplainabilityJobDefinitions(ListModelExplainabilityJobDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelMetadataResult listModelMetadata(ListModelMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelPackageGroupsResult listModelPackageGroups(ListModelPackageGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelPackagesResult listModelPackages(ListModelPackagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelQualityJobDefinitionsResult listModelQualityJobDefinitions(ListModelQualityJobDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelsResult listModels(ListModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitoringAlertHistoryResult listMonitoringAlertHistory(ListMonitoringAlertHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitoringAlertsResult listMonitoringAlerts(ListMonitoringAlertsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitoringExecutionsResult listMonitoringExecutions(ListMonitoringExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitoringSchedulesResult listMonitoringSchedules(ListMonitoringSchedulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotebookInstanceLifecycleConfigsResult listNotebookInstanceLifecycleConfigs(ListNotebookInstanceLifecycleConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotebookInstancesResult listNotebookInstances(ListNotebookInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPipelineExecutionStepsResult listPipelineExecutionSteps(ListPipelineExecutionStepsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPipelineExecutionsResult listPipelineExecutions(ListPipelineExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPipelineParametersForExecutionResult listPipelineParametersForExecution(ListPipelineParametersForExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProcessingJobsResult listProcessingJobs(ListProcessingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceCatalogsResult listResourceCatalogs(ListResourceCatalogsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSpacesResult listSpaces(ListSpacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStageDevicesResult listStageDevices(ListStageDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStudioLifecycleConfigsResult listStudioLifecycleConfigs(ListStudioLifecycleConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscribedWorkteamsResult listSubscribedWorkteams(ListSubscribedWorkteamsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrainingJobsResult listTrainingJobs(ListTrainingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrainingJobsForHyperParameterTuningJobResult listTrainingJobsForHyperParameterTuningJob(ListTrainingJobsForHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTransformJobsResult listTransformJobs(ListTransformJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrialComponentsResult listTrialComponents(ListTrialComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrialsResult listTrials(ListTrialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUserProfilesResult listUserProfiles(ListUserProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkforcesResult listWorkforces(ListWorkforcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkteamsResult listWorkteams(ListWorkteamsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutModelPackageGroupPolicyResult putModelPackageGroupPolicy(PutModelPackageGroupPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public QueryLineageResult queryLineage(QueryLineageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterDevicesResult registerDevices(RegisterDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RenderUiTemplateResult renderUiTemplate(RenderUiTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RetryPipelineExecutionResult retryPipelineExecution(RetryPipelineExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchResult search(SearchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendPipelineExecutionStepFailureResult sendPipelineExecutionStepFailure(SendPipelineExecutionStepFailureRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendPipelineExecutionStepSuccessResult sendPipelineExecutionStepSuccess(SendPipelineExecutionStepSuccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartEdgeDeploymentStageResult startEdgeDeploymentStage(StartEdgeDeploymentStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartInferenceExperimentResult startInferenceExperiment(StartInferenceExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMlflowTrackingServerResult startMlflowTrackingServer(StartMlflowTrackingServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMonitoringScheduleResult startMonitoringSchedule(StartMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartNotebookInstanceResult startNotebookInstance(StartNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartPipelineExecutionResult startPipelineExecution(StartPipelineExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopAutoMLJobResult stopAutoMLJob(StopAutoMLJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopCompilationJobResult stopCompilationJob(StopCompilationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopEdgeDeploymentStageResult stopEdgeDeploymentStage(StopEdgeDeploymentStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopEdgePackagingJobResult stopEdgePackagingJob(StopEdgePackagingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopHyperParameterTuningJobResult stopHyperParameterTuningJob(StopHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopInferenceExperimentResult stopInferenceExperiment(StopInferenceExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopInferenceRecommendationsJobResult stopInferenceRecommendationsJob(StopInferenceRecommendationsJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopLabelingJobResult stopLabelingJob(StopLabelingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopMlflowTrackingServerResult stopMlflowTrackingServer(StopMlflowTrackingServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopMonitoringScheduleResult stopMonitoringSchedule(StopMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopNotebookInstanceResult stopNotebookInstance(StopNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopPipelineExecutionResult stopPipelineExecution(StopPipelineExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopProcessingJobResult stopProcessingJob(StopProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTrainingJobResult stopTrainingJob(StopTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTransformJobResult stopTransformJob(StopTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateActionResult updateAction(UpdateActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppImageConfigResult updateAppImageConfig(UpdateAppImageConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateArtifactResult updateArtifact(UpdateArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateClusterResult updateCluster(UpdateClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateClusterSoftwareResult updateClusterSoftware(UpdateClusterSoftwareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCodeRepositoryResult updateCodeRepository(UpdateCodeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateContextResult updateContext(UpdateContextRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeviceFleetResult updateDeviceFleet(UpdateDeviceFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDevicesResult updateDevices(UpdateDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDomainResult updateDomain(UpdateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointResult updateEndpoint(UpdateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointWeightsAndCapacitiesResult updateEndpointWeightsAndCapacities(UpdateEndpointWeightsAndCapacitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateExperimentResult updateExperiment(UpdateExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFeatureGroupResult updateFeatureGroup(UpdateFeatureGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFeatureMetadataResult updateFeatureMetadata(UpdateFeatureMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateHubResult updateHub(UpdateHubRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateImageResult updateImage(UpdateImageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateImageVersionResult updateImageVersion(UpdateImageVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInferenceComponentResult updateInferenceComponent(UpdateInferenceComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInferenceComponentRuntimeConfigResult updateInferenceComponentRuntimeConfig(UpdateInferenceComponentRuntimeConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInferenceExperimentResult updateInferenceExperiment(UpdateInferenceExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMlflowTrackingServerResult updateMlflowTrackingServer(UpdateMlflowTrackingServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateModelCardResult updateModelCard(UpdateModelCardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateModelPackageResult updateModelPackage(UpdateModelPackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMonitoringAlertResult updateMonitoringAlert(UpdateMonitoringAlertRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMonitoringScheduleResult updateMonitoringSchedule(UpdateMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNotebookInstanceResult updateNotebookInstance(UpdateNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNotebookInstanceLifecycleConfigResult updateNotebookInstanceLifecycleConfig(UpdateNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePipelineExecutionResult updatePipelineExecution(UpdatePipelineExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSpaceResult updateSpace(UpdateSpaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrainingJobResult updateTrainingJob(UpdateTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrialResult updateTrial(UpdateTrialRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrialComponentResult updateTrialComponent(UpdateTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserProfileResult updateUserProfile(UpdateUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkforceResult updateWorkforce(UpdateWorkforceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkteamResult updateWorkteam(UpdateWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AmazonSageMakerWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
