/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.SourceAlgorithm;

@SdkInternalApi
public class SourceAlgorithmMarshaller {
    private static final MarshallingInfo<String> MODELDATAURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelDataUrl").build();
    private static final MarshallingInfo<StructuredPojo> MODELDATASOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelDataSource").build();
    private static final MarshallingInfo<String> ALGORITHMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlgorithmName").build();
    private static final SourceAlgorithmMarshaller instance = new SourceAlgorithmMarshaller();

    public static SourceAlgorithmMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceAlgorithm sourceAlgorithm, ProtocolMarshaller protocolMarshaller) {
        if (sourceAlgorithm == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sourceAlgorithm.getModelDataUrl(), MODELDATAURL_BINDING);
            protocolMarshaller.marshall((Object)sourceAlgorithm.getModelDataSource(), MODELDATASOURCE_BINDING);
            protocolMarshaller.marshall((Object)sourceAlgorithm.getAlgorithmName(), ALGORITHMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

