/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.OptimizationConfig;
import com.amazonaws.services.sagemaker.model.OptimizationJobDeploymentInstanceType;
import com.amazonaws.services.sagemaker.model.OptimizationJobModelSource;
import com.amazonaws.services.sagemaker.model.OptimizationJobOutputConfig;
import com.amazonaws.services.sagemaker.model.OptimizationVpcConfig;
import com.amazonaws.services.sagemaker.model.StoppingCondition;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateOptimizationJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String optimizationJobName;
    private String roleArn;
    private OptimizationJobModelSource modelSource;
    private String deploymentInstanceType;
    private Map<String, String> optimizationEnvironment;
    private List<OptimizationConfig> optimizationConfigs;
    private OptimizationJobOutputConfig outputConfig;
    private StoppingCondition stoppingCondition;
    private List<Tag> tags;
    private OptimizationVpcConfig vpcConfig;

    public void setOptimizationJobName(String optimizationJobName) {
        this.optimizationJobName = optimizationJobName;
    }

    public String getOptimizationJobName() {
        return this.optimizationJobName;
    }

    public CreateOptimizationJobRequest withOptimizationJobName(String optimizationJobName) {
        this.setOptimizationJobName(optimizationJobName);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateOptimizationJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setModelSource(OptimizationJobModelSource modelSource) {
        this.modelSource = modelSource;
    }

    public OptimizationJobModelSource getModelSource() {
        return this.modelSource;
    }

    public CreateOptimizationJobRequest withModelSource(OptimizationJobModelSource modelSource) {
        this.setModelSource(modelSource);
        return this;
    }

    public void setDeploymentInstanceType(String deploymentInstanceType) {
        this.deploymentInstanceType = deploymentInstanceType;
    }

    public String getDeploymentInstanceType() {
        return this.deploymentInstanceType;
    }

    public CreateOptimizationJobRequest withDeploymentInstanceType(String deploymentInstanceType) {
        this.setDeploymentInstanceType(deploymentInstanceType);
        return this;
    }

    public CreateOptimizationJobRequest withDeploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType) {
        this.deploymentInstanceType = deploymentInstanceType.toString();
        return this;
    }

    public Map<String, String> getOptimizationEnvironment() {
        return this.optimizationEnvironment;
    }

    public void setOptimizationEnvironment(Map<String, String> optimizationEnvironment) {
        this.optimizationEnvironment = optimizationEnvironment;
    }

    public CreateOptimizationJobRequest withOptimizationEnvironment(Map<String, String> optimizationEnvironment) {
        this.setOptimizationEnvironment(optimizationEnvironment);
        return this;
    }

    public CreateOptimizationJobRequest addOptimizationEnvironmentEntry(String key, String value) {
        if (null == this.optimizationEnvironment) {
            this.optimizationEnvironment = new HashMap<String, String>();
        }
        if (this.optimizationEnvironment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.optimizationEnvironment.put(key, value);
        return this;
    }

    public CreateOptimizationJobRequest clearOptimizationEnvironmentEntries() {
        this.optimizationEnvironment = null;
        return this;
    }

    public List<OptimizationConfig> getOptimizationConfigs() {
        return this.optimizationConfigs;
    }

    public void setOptimizationConfigs(Collection<OptimizationConfig> optimizationConfigs) {
        if (optimizationConfigs == null) {
            this.optimizationConfigs = null;
            return;
        }
        this.optimizationConfigs = new ArrayList<OptimizationConfig>(optimizationConfigs);
    }

    public CreateOptimizationJobRequest withOptimizationConfigs(OptimizationConfig ... optimizationConfigs) {
        if (this.optimizationConfigs == null) {
            this.setOptimizationConfigs(new ArrayList<OptimizationConfig>(optimizationConfigs.length));
        }
        for (OptimizationConfig ele : optimizationConfigs) {
            this.optimizationConfigs.add(ele);
        }
        return this;
    }

    public CreateOptimizationJobRequest withOptimizationConfigs(Collection<OptimizationConfig> optimizationConfigs) {
        this.setOptimizationConfigs(optimizationConfigs);
        return this;
    }

    public void setOutputConfig(OptimizationJobOutputConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    public OptimizationJobOutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    public CreateOptimizationJobRequest withOutputConfig(OptimizationJobOutputConfig outputConfig) {
        this.setOutputConfig(outputConfig);
        return this;
    }

    public void setStoppingCondition(StoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public StoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public CreateOptimizationJobRequest withStoppingCondition(StoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateOptimizationJobRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateOptimizationJobRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVpcConfig(OptimizationVpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public OptimizationVpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public CreateOptimizationJobRequest withVpcConfig(OptimizationVpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptimizationJobName() != null) {
            sb.append("OptimizationJobName: ").append(this.getOptimizationJobName()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getModelSource() != null) {
            sb.append("ModelSource: ").append(this.getModelSource()).append(",");
        }
        if (this.getDeploymentInstanceType() != null) {
            sb.append("DeploymentInstanceType: ").append(this.getDeploymentInstanceType()).append(",");
        }
        if (this.getOptimizationEnvironment() != null) {
            sb.append("OptimizationEnvironment: ").append(this.getOptimizationEnvironment()).append(",");
        }
        if (this.getOptimizationConfigs() != null) {
            sb.append("OptimizationConfigs: ").append(this.getOptimizationConfigs()).append(",");
        }
        if (this.getOutputConfig() != null) {
            sb.append("OutputConfig: ").append(this.getOutputConfig()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOptimizationJobRequest)) {
            return false;
        }
        CreateOptimizationJobRequest other = (CreateOptimizationJobRequest)obj;
        if (other.getOptimizationJobName() == null ^ this.getOptimizationJobName() == null) {
            return false;
        }
        if (other.getOptimizationJobName() != null && !other.getOptimizationJobName().equals(this.getOptimizationJobName())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getModelSource() == null ^ this.getModelSource() == null) {
            return false;
        }
        if (other.getModelSource() != null && !other.getModelSource().equals(this.getModelSource())) {
            return false;
        }
        if (other.getDeploymentInstanceType() == null ^ this.getDeploymentInstanceType() == null) {
            return false;
        }
        if (other.getDeploymentInstanceType() != null && !other.getDeploymentInstanceType().equals(this.getDeploymentInstanceType())) {
            return false;
        }
        if (other.getOptimizationEnvironment() == null ^ this.getOptimizationEnvironment() == null) {
            return false;
        }
        if (other.getOptimizationEnvironment() != null && !other.getOptimizationEnvironment().equals(this.getOptimizationEnvironment())) {
            return false;
        }
        if (other.getOptimizationConfigs() == null ^ this.getOptimizationConfigs() == null) {
            return false;
        }
        if (other.getOptimizationConfigs() != null && !other.getOptimizationConfigs().equals(this.getOptimizationConfigs())) {
            return false;
        }
        if (other.getOutputConfig() == null ^ this.getOutputConfig() == null) {
            return false;
        }
        if (other.getOutputConfig() != null && !other.getOutputConfig().equals(this.getOutputConfig())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        if (other.getStoppingCondition() != null && !other.getStoppingCondition().equals(this.getStoppingCondition())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        return other.getVpcConfig() == null || other.getVpcConfig().equals(this.getVpcConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptimizationJobName() == null ? 0 : this.getOptimizationJobName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getModelSource() == null ? 0 : this.getModelSource().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentInstanceType() == null ? 0 : this.getDeploymentInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getOptimizationEnvironment() == null ? 0 : this.getOptimizationEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getOptimizationConfigs() == null ? 0 : this.getOptimizationConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getOutputConfig() == null ? 0 : this.getOutputConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        return hashCode;
    }

    public CreateOptimizationJobRequest clone() {
        return (CreateOptimizationJobRequest)super.clone();
    }
}

