/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The list of key-value pairs used to filter your search results. If a search result contains a key from your list, it
 * is included in the final search response if the value associated with the key in the result matches the value you
 * specified. If the value doesn't match, the result is excluded from the search response. Any resources that don't have
 * a key from the list that you've provided will also be included in the search response.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/VisibilityConditions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class VisibilityConditions implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The key that specifies the tag that you're using to filter the search results. It must be in the following
     * format: <code>Tags.&lt;key&gt;</code>.
     * </p>
     */
    private String key;
    /**
     * <p>
     * The value for the tag that you're using to filter the search results.
     * </p>
     */
    private String value;

    /**
     * <p>
     * The key that specifies the tag that you're using to filter the search results. It must be in the following
     * format: <code>Tags.&lt;key&gt;</code>.
     * </p>
     * 
     * @param key
     *        The key that specifies the tag that you're using to filter the search results. It must be in the following
     *        format: <code>Tags.&lt;key&gt;</code>.
     */

    public void setKey(String key) {
        this.key = key;
    }

    /**
     * <p>
     * The key that specifies the tag that you're using to filter the search results. It must be in the following
     * format: <code>Tags.&lt;key&gt;</code>.
     * </p>
     * 
     * @return The key that specifies the tag that you're using to filter the search results. It must be in the
     *         following format: <code>Tags.&lt;key&gt;</code>.
     */

    public String getKey() {
        return this.key;
    }

    /**
     * <p>
     * The key that specifies the tag that you're using to filter the search results. It must be in the following
     * format: <code>Tags.&lt;key&gt;</code>.
     * </p>
     * 
     * @param key
     *        The key that specifies the tag that you're using to filter the search results. It must be in the following
     *        format: <code>Tags.&lt;key&gt;</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VisibilityConditions withKey(String key) {
        setKey(key);
        return this;
    }

    /**
     * <p>
     * The value for the tag that you're using to filter the search results.
     * </p>
     * 
     * @param value
     *        The value for the tag that you're using to filter the search results.
     */

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * <p>
     * The value for the tag that you're using to filter the search results.
     * </p>
     * 
     * @return The value for the tag that you're using to filter the search results.
     */

    public String getValue() {
        return this.value;
    }

    /**
     * <p>
     * The value for the tag that you're using to filter the search results.
     * </p>
     * 
     * @param value
     *        The value for the tag that you're using to filter the search results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public VisibilityConditions withValue(String value) {
        setValue(value);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getKey() != null)
            sb.append("Key: ").append(getKey()).append(",");
        if (getValue() != null)
            sb.append("Value: ").append(getValue());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof VisibilityConditions == false)
            return false;
        VisibilityConditions other = (VisibilityConditions) obj;
        if (other.getKey() == null ^ this.getKey() == null)
            return false;
        if (other.getKey() != null && other.getKey().equals(this.getKey()) == false)
            return false;
        if (other.getValue() == null ^ this.getValue() == null)
            return false;
        if (other.getValue() != null && other.getValue().equals(this.getValue()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getKey() == null) ? 0 : getKey().hashCode());
        hashCode = prime * hashCode + ((getValue() == null) ? 0 : getValue().hashCode());
        return hashCode;
    }

    @Override
    public VisibilityConditions clone() {
        try {
            return (VisibilityConditions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemaker.model.transform.VisibilityConditionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
