/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.sagemaker.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SpaceDetails JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SpaceDetailsJsonUnmarshaller implements Unmarshaller<SpaceDetails, JsonUnmarshallerContext> {

    public SpaceDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        SpaceDetails spaceDetails = new SpaceDetails();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DomainId", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setDomainId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SpaceName", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setSpaceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setCreationTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setLastModifiedTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("SpaceSettingsSummary", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setSpaceSettingsSummary(SpaceSettingsSummaryJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SpaceSharingSettingsSummary", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setSpaceSharingSettingsSummary(SpaceSharingSettingsSummaryJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("OwnershipSettingsSummary", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setOwnershipSettingsSummary(OwnershipSettingsSummaryJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SpaceDisplayName", targetDepth)) {
                    context.nextToken();
                    spaceDetails.setSpaceDisplayName(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return spaceDetails;
    }

    private static SpaceDetailsJsonUnmarshaller instance;

    public static SpaceDetailsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new SpaceDetailsJsonUnmarshaller();
        return instance;
    }
}
