/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.sagemaker.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * CreateAutoMLJobV2RequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class CreateAutoMLJobV2RequestMarshaller {

    private static final MarshallingInfo<String> AUTOMLJOBNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoMLJobName").build();
    private static final MarshallingInfo<List> AUTOMLJOBINPUTDATACONFIG_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoMLJobInputDataConfig").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").build();
    private static final MarshallingInfo<StructuredPojo> AUTOMLPROBLEMTYPECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoMLProblemTypeConfig").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Tags").build();
    private static final MarshallingInfo<StructuredPojo> SECURITYCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityConfig").build();
    private static final MarshallingInfo<StructuredPojo> AUTOMLJOBOBJECTIVE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoMLJobObjective").build();
    private static final MarshallingInfo<StructuredPojo> MODELDEPLOYCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelDeployConfig").build();
    private static final MarshallingInfo<StructuredPojo> DATASPLITCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSplitConfig").build();

    private static final CreateAutoMLJobV2RequestMarshaller instance = new CreateAutoMLJobV2RequestMarshaller();

    public static CreateAutoMLJobV2RequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CreateAutoMLJobV2Request createAutoMLJobV2Request, ProtocolMarshaller protocolMarshaller) {

        if (createAutoMLJobV2Request == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(createAutoMLJobV2Request.getAutoMLJobName(), AUTOMLJOBNAME_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getAutoMLJobInputDataConfig(), AUTOMLJOBINPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getOutputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getAutoMLProblemTypeConfig(), AUTOMLPROBLEMTYPECONFIG_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getSecurityConfig(), SECURITYCONFIG_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getAutoMLJobObjective(), AUTOMLJOBOBJECTIVE_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getModelDeployConfig(), MODELDEPLOYCONFIG_BINDING);
            protocolMarshaller.marshall(createAutoMLJobV2Request.getDataSplitConfig(), DATASPLITCONFIG_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
