/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCard" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateModelCardResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the successfully created model card.
     * </p>
     */
    private String modelCardArn;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the successfully created model card.
     * </p>
     * 
     * @param modelCardArn
     *        The Amazon Resource Name (ARN) of the successfully created model card.
     */

    public void setModelCardArn(String modelCardArn) {
        this.modelCardArn = modelCardArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the successfully created model card.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the successfully created model card.
     */

    public String getModelCardArn() {
        return this.modelCardArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the successfully created model card.
     * </p>
     * 
     * @param modelCardArn
     *        The Amazon Resource Name (ARN) of the successfully created model card.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateModelCardResult withModelCardArn(String modelCardArn) {
        setModelCardArn(modelCardArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getModelCardArn() != null)
            sb.append("ModelCardArn: ").append(getModelCardArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateModelCardResult == false)
            return false;
        CreateModelCardResult other = (CreateModelCardResult) obj;
        if (other.getModelCardArn() == null ^ this.getModelCardArn() == null)
            return false;
        if (other.getModelCardArn() != null && other.getModelCardArn().equals(this.getModelCardArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getModelCardArn() == null) ? 0 : getModelCardArn().hashCode());
        return hashCode;
    }

    @Override
    public CreateModelCardResult clone() {
        try {
            return (CreateModelCardResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
