/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples;

import com.amazonaws.util.ParsingUtils;
import java.util.ArrayList;
import java.util.List;

public class CodeSample {
    private final String id;
    private final String serviceName;
    private String title;
    private String description;
    private List<String> codeLines;

    public CodeSample(String sampleId, String serviceName) {
        if (sampleId == null || sampleId.isEmpty()) {
            throw new IllegalArgumentException("Sample ID must be provided!");
        }
        if (serviceName == null || serviceName.isEmpty()) {
            throw new IllegalArgumentException("Service name must be provided!");
        }
        this.id = sampleId;
        this.serviceName = serviceName;
        this.codeLines = new ArrayList<String>();
    }

    public String getId() {
        return this.id;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormattedCode() {
        int offset = ParsingUtils.getMinWhitespace(this.codeLines);
        return ParsingUtils.formatSampleText(this.codeLines, offset);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void appendLine(String line) {
        this.codeLines.add(line);
    }
}

