/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.codesamples.exception.SampleParsingException;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParsingUtils {
    public static boolean fileMatchesExtension(File file, String targetExtension) {
        String actualExtension;
        String fileName = file.getName();
        int i = fileName.lastIndexOf(".");
        return i > 0 && targetExtension.equals(actualExtension = fileName.substring(i + 1));
    }

    public static String formatSampleText(List<String> lines, int maxTrim) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            sb.append(ParsingUtils.trimLeadingWhitespace(lines.get(i), maxTrim));
            if (i + 1 >= lines.size()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int getMinWhitespace(List<String> lines) {
        int minWhitespace = 0;
        for (String line : lines) {
            int lineLeadingWhitespace = ParsingUtils.getLeadingWhitespace(line);
            if (lineLeadingWhitespace >= minWhitespace && minWhitespace != 0) continue;
            minWhitespace = lineLeadingWhitespace;
        }
        return minWhitespace;
    }

    public static int getLeadingWhitespace(String str) {
        int pos;
        for (pos = 0; pos < str.length() && str.charAt(pos) == ' '; ++pos) {
        }
        return pos;
    }

    public static String trimLeadingWhitespace(String str, int max) {
        int pos = Math.min(ParsingUtils.getLeadingWhitespace(str), max);
        if (pos > 0) {
            return str.substring(pos);
        }
        return str;
    }

    public static String assertFieldHasContent(String field, String value) {
        if (!ParsingUtils.hasContent(value)) {
            throw new SampleParsingException(String.format("Required field %s was not provided!", field));
        }
        return value;
    }

    public static boolean checkAndLogIfNoContent(String sampleId, String field, String value) {
        if (!ParsingUtils.hasContent(value)) {
            System.err.println(String.format("Warning: Sample '%s' does not provide field '%s'", sampleId, field));
            return true;
        }
        return false;
    }

    private static boolean hasContent(String str) {
        return str != null && !str.isEmpty();
    }
}

