/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.savingsplans;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.savingsplans.AWSSavingsPlansAsync;
import com.amazonaws.services.savingsplans.AWSSavingsPlansAsyncClientBuilder;
import com.amazonaws.services.savingsplans.AWSSavingsPlansClient;
import com.amazonaws.services.savingsplans.model.CreateSavingsPlanRequest;
import com.amazonaws.services.savingsplans.model.CreateSavingsPlanResult;
import com.amazonaws.services.savingsplans.model.DescribeSavingsPlanRatesRequest;
import com.amazonaws.services.savingsplans.model.DescribeSavingsPlanRatesResult;
import com.amazonaws.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest;
import com.amazonaws.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResult;
import com.amazonaws.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest;
import com.amazonaws.services.savingsplans.model.DescribeSavingsPlansOfferingsResult;
import com.amazonaws.services.savingsplans.model.DescribeSavingsPlansRequest;
import com.amazonaws.services.savingsplans.model.DescribeSavingsPlansResult;
import com.amazonaws.services.savingsplans.model.ListTagsForResourceRequest;
import com.amazonaws.services.savingsplans.model.ListTagsForResourceResult;
import com.amazonaws.services.savingsplans.model.TagResourceRequest;
import com.amazonaws.services.savingsplans.model.TagResourceResult;
import com.amazonaws.services.savingsplans.model.UntagResourceRequest;
import com.amazonaws.services.savingsplans.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSavingsPlansAsyncClient
extends AWSSavingsPlansClient
implements AWSSavingsPlansAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSavingsPlansAsyncClientBuilder asyncBuilder() {
        return AWSSavingsPlansAsyncClientBuilder.standard();
    }

    AWSSavingsPlansAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSavingsPlansAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateSavingsPlanResult> createSavingsPlanAsync(CreateSavingsPlanRequest request) {
        return this.createSavingsPlanAsync(request, null);
    }

    @Override
    public Future<CreateSavingsPlanResult> createSavingsPlanAsync(CreateSavingsPlanRequest request, final AsyncHandler<CreateSavingsPlanRequest, CreateSavingsPlanResult> asyncHandler) {
        final CreateSavingsPlanRequest finalRequest = (CreateSavingsPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSavingsPlanResult>(){

            @Override
            public CreateSavingsPlanResult call() throws Exception {
                CreateSavingsPlanResult result = null;
                try {
                    result = AWSSavingsPlansAsyncClient.this.executeCreateSavingsPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSavingsPlanRatesResult> describeSavingsPlanRatesAsync(DescribeSavingsPlanRatesRequest request) {
        return this.describeSavingsPlanRatesAsync(request, null);
    }

    @Override
    public Future<DescribeSavingsPlanRatesResult> describeSavingsPlanRatesAsync(DescribeSavingsPlanRatesRequest request, final AsyncHandler<DescribeSavingsPlanRatesRequest, DescribeSavingsPlanRatesResult> asyncHandler) {
        final DescribeSavingsPlanRatesRequest finalRequest = (DescribeSavingsPlanRatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSavingsPlanRatesResult>(){

            @Override
            public DescribeSavingsPlanRatesResult call() throws Exception {
                DescribeSavingsPlanRatesResult result = null;
                try {
                    result = AWSSavingsPlansAsyncClient.this.executeDescribeSavingsPlanRates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSavingsPlansResult> describeSavingsPlansAsync(DescribeSavingsPlansRequest request) {
        return this.describeSavingsPlansAsync(request, null);
    }

    @Override
    public Future<DescribeSavingsPlansResult> describeSavingsPlansAsync(DescribeSavingsPlansRequest request, final AsyncHandler<DescribeSavingsPlansRequest, DescribeSavingsPlansResult> asyncHandler) {
        final DescribeSavingsPlansRequest finalRequest = (DescribeSavingsPlansRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSavingsPlansResult>(){

            @Override
            public DescribeSavingsPlansResult call() throws Exception {
                DescribeSavingsPlansResult result = null;
                try {
                    result = AWSSavingsPlansAsyncClient.this.executeDescribeSavingsPlans(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSavingsPlansOfferingRatesResult> describeSavingsPlansOfferingRatesAsync(DescribeSavingsPlansOfferingRatesRequest request) {
        return this.describeSavingsPlansOfferingRatesAsync(request, null);
    }

    @Override
    public Future<DescribeSavingsPlansOfferingRatesResult> describeSavingsPlansOfferingRatesAsync(DescribeSavingsPlansOfferingRatesRequest request, final AsyncHandler<DescribeSavingsPlansOfferingRatesRequest, DescribeSavingsPlansOfferingRatesResult> asyncHandler) {
        final DescribeSavingsPlansOfferingRatesRequest finalRequest = (DescribeSavingsPlansOfferingRatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSavingsPlansOfferingRatesResult>(){

            @Override
            public DescribeSavingsPlansOfferingRatesResult call() throws Exception {
                DescribeSavingsPlansOfferingRatesResult result = null;
                try {
                    result = AWSSavingsPlansAsyncClient.this.executeDescribeSavingsPlansOfferingRates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSavingsPlansOfferingsResult> describeSavingsPlansOfferingsAsync(DescribeSavingsPlansOfferingsRequest request) {
        return this.describeSavingsPlansOfferingsAsync(request, null);
    }

    @Override
    public Future<DescribeSavingsPlansOfferingsResult> describeSavingsPlansOfferingsAsync(DescribeSavingsPlansOfferingsRequest request, final AsyncHandler<DescribeSavingsPlansOfferingsRequest, DescribeSavingsPlansOfferingsResult> asyncHandler) {
        final DescribeSavingsPlansOfferingsRequest finalRequest = (DescribeSavingsPlansOfferingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSavingsPlansOfferingsResult>(){

            @Override
            public DescribeSavingsPlansOfferingsResult call() throws Exception {
                DescribeSavingsPlansOfferingsResult result = null;
                try {
                    result = AWSSavingsPlansAsyncClient.this.executeDescribeSavingsPlansOfferings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSSavingsPlansAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSavingsPlansAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSavingsPlansAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

