/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemas.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.schemas.model.DiscovererSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDiscoverersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DiscovererSummary> discoverers;
    private String nextToken;

    public List<DiscovererSummary> getDiscoverers() {
        return this.discoverers;
    }

    public void setDiscoverers(Collection<DiscovererSummary> discoverers) {
        if (discoverers == null) {
            this.discoverers = null;
            return;
        }
        this.discoverers = new ArrayList<DiscovererSummary>(discoverers);
    }

    public ListDiscoverersResult withDiscoverers(DiscovererSummary ... discoverers) {
        if (this.discoverers == null) {
            this.setDiscoverers(new ArrayList<DiscovererSummary>(discoverers.length));
        }
        for (DiscovererSummary ele : discoverers) {
            this.discoverers.add(ele);
        }
        return this;
    }

    public ListDiscoverersResult withDiscoverers(Collection<DiscovererSummary> discoverers) {
        this.setDiscoverers(discoverers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDiscoverersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDiscoverers() != null) {
            sb.append("Discoverers: ").append(this.getDiscoverers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoverersResult)) {
            return false;
        }
        ListDiscoverersResult other = (ListDiscoverersResult)obj;
        if (other.getDiscoverers() == null ^ this.getDiscoverers() == null) {
            return false;
        }
        if (other.getDiscoverers() != null && !other.getDiscoverers().equals(this.getDiscoverers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDiscoverers() == null ? 0 : this.getDiscoverers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDiscoverersResult clone() {
        try {
            return (ListDiscoverersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

