/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.securityhub.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * VulnerabilityMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class VulnerabilityMarshaller {

    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Id").build();
    private static final MarshallingInfo<List> VULNERABLEPACKAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VulnerablePackages").build();
    private static final MarshallingInfo<List> CVSS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Cvss").build();
    private static final MarshallingInfo<List> RELATEDVULNERABILITIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelatedVulnerabilities").build();
    private static final MarshallingInfo<StructuredPojo> VENDOR_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Vendor").build();
    private static final MarshallingInfo<List> REFERENCEURLS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReferenceUrls").build();
    private static final MarshallingInfo<String> FIXAVAILABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixAvailable").build();
    private static final MarshallingInfo<Double> EPSSSCORE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EpssScore").build();
    private static final MarshallingInfo<String> EXPLOITAVAILABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExploitAvailable").build();
    private static final MarshallingInfo<List> CODEVULNERABILITIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeVulnerabilities").build();

    private static final VulnerabilityMarshaller instance = new VulnerabilityMarshaller();

    public static VulnerabilityMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Vulnerability vulnerability, ProtocolMarshaller protocolMarshaller) {

        if (vulnerability == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(vulnerability.getId(), ID_BINDING);
            protocolMarshaller.marshall(vulnerability.getVulnerablePackages(), VULNERABLEPACKAGES_BINDING);
            protocolMarshaller.marshall(vulnerability.getCvss(), CVSS_BINDING);
            protocolMarshaller.marshall(vulnerability.getRelatedVulnerabilities(), RELATEDVULNERABILITIES_BINDING);
            protocolMarshaller.marshall(vulnerability.getVendor(), VENDOR_BINDING);
            protocolMarshaller.marshall(vulnerability.getReferenceUrls(), REFERENCEURLS_BINDING);
            protocolMarshaller.marshall(vulnerability.getFixAvailable(), FIXAVAILABLE_BINDING);
            protocolMarshaller.marshall(vulnerability.getEpssScore(), EPSSSCORE_BINDING);
            protocolMarshaller.marshall(vulnerability.getExploitAvailable(), EXPLOITAVAILABLE_BINDING);
            protocolMarshaller.marshall(vulnerability.getCodeVulnerabilities(), CODEVULNERABILITIES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
