/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A stateless rule in the rule group.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/RuleGroupSourceStatelessRulesDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RuleGroupSourceStatelessRulesDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     * </p>
     */
    private Integer priority;
    /**
     * <p>
     * Provides the definition of the stateless rule.
     * </p>
     */
    private RuleGroupSourceStatelessRuleDefinition ruleDefinition;

    /**
     * <p>
     * Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     * </p>
     * 
     * @param priority
     *        Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     */

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    /**
     * <p>
     * Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     * </p>
     * 
     * @return Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     */

    public Integer getPriority() {
        return this.priority;
    }

    /**
     * <p>
     * Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     * </p>
     * 
     * @param priority
     *        Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RuleGroupSourceStatelessRulesDetails withPriority(Integer priority) {
        setPriority(priority);
        return this;
    }

    /**
     * <p>
     * Provides the definition of the stateless rule.
     * </p>
     * 
     * @param ruleDefinition
     *        Provides the definition of the stateless rule.
     */

    public void setRuleDefinition(RuleGroupSourceStatelessRuleDefinition ruleDefinition) {
        this.ruleDefinition = ruleDefinition;
    }

    /**
     * <p>
     * Provides the definition of the stateless rule.
     * </p>
     * 
     * @return Provides the definition of the stateless rule.
     */

    public RuleGroupSourceStatelessRuleDefinition getRuleDefinition() {
        return this.ruleDefinition;
    }

    /**
     * <p>
     * Provides the definition of the stateless rule.
     * </p>
     * 
     * @param ruleDefinition
     *        Provides the definition of the stateless rule.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RuleGroupSourceStatelessRulesDetails withRuleDefinition(RuleGroupSourceStatelessRuleDefinition ruleDefinition) {
        setRuleDefinition(ruleDefinition);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPriority() != null)
            sb.append("Priority: ").append(getPriority()).append(",");
        if (getRuleDefinition() != null)
            sb.append("RuleDefinition: ").append(getRuleDefinition());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RuleGroupSourceStatelessRulesDetails == false)
            return false;
        RuleGroupSourceStatelessRulesDetails other = (RuleGroupSourceStatelessRulesDetails) obj;
        if (other.getPriority() == null ^ this.getPriority() == null)
            return false;
        if (other.getPriority() != null && other.getPriority().equals(this.getPriority()) == false)
            return false;
        if (other.getRuleDefinition() == null ^ this.getRuleDefinition() == null)
            return false;
        if (other.getRuleDefinition() != null && other.getRuleDefinition().equals(this.getRuleDefinition()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPriority() == null) ? 0 : getPriority().hashCode());
        hashCode = prime * hashCode + ((getRuleDefinition() == null) ? 0 : getRuleDefinition().hashCode());
        return hashCode;
    }

    @Override
    public RuleGroupSourceStatelessRulesDetails clone() {
        try {
            return (RuleGroupSourceStatelessRulesDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.RuleGroupSourceStatelessRulesDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
