/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.securityhub.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AwsAppSyncGraphQlApiDetails JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsAppSyncGraphQlApiDetailsJsonUnmarshaller implements Unmarshaller<AwsAppSyncGraphQlApiDetails, JsonUnmarshallerContext> {

    public AwsAppSyncGraphQlApiDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsAppSyncGraphQlApiDetails awsAppSyncGraphQlApiDetails = new AwsAppSyncGraphQlApiDetails();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ApiId", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setApiId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OpenIdConnectConfig", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setOpenIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetailsJsonUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LambdaAuthorizerConfig", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setLambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetailsJsonUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("XrayEnabled", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setXrayEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("UserPoolConfig", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setUserPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AuthenticationType", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setAuthenticationType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LogConfig", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setLogConfig(AwsAppSyncGraphQlApiLogConfigDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AdditionalAuthenticationProviders", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails
                            .setAdditionalAuthenticationProviders(new ListUnmarshaller<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails>(
                                    AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetailsJsonUnmarshaller.getInstance())

                            .unmarshall(context));
                }
                if (context.testExpression("WafWebAclArn", targetDepth)) {
                    context.nextToken();
                    awsAppSyncGraphQlApiDetails.setWafWebAclArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return awsAppSyncGraphQlApiDetails;
    }

    private static AwsAppSyncGraphQlApiDetailsJsonUnmarshaller instance;

    public static AwsAppSyncGraphQlApiDetailsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AwsAppSyncGraphQlApiDetailsJsonUnmarshaller();
        return instance;
    }
}
