/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securitylake;

import javax.annotation.Generated;

import com.amazonaws.services.securitylake.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonSecurityLake}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonSecurityLake implements AmazonSecurityLake {

    protected AbstractAmazonSecurityLake() {
    }

    @Override
    public CreateAwsLogSourceResult createAwsLogSource(CreateAwsLogSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCustomLogSourceResult createCustomLogSource(CreateCustomLogSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataLakeResult createDataLake(CreateDataLakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataLakeExceptionSubscriptionResult createDataLakeExceptionSubscription(CreateDataLakeExceptionSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataLakeOrganizationConfigurationResult createDataLakeOrganizationConfiguration(CreateDataLakeOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriberResult createSubscriber(CreateSubscriberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriberNotificationResult createSubscriberNotification(CreateSubscriberNotificationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAwsLogSourceResult deleteAwsLogSource(DeleteAwsLogSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCustomLogSourceResult deleteCustomLogSource(DeleteCustomLogSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataLakeResult deleteDataLake(DeleteDataLakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataLakeExceptionSubscriptionResult deleteDataLakeExceptionSubscription(DeleteDataLakeExceptionSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataLakeOrganizationConfigurationResult deleteDataLakeOrganizationConfiguration(DeleteDataLakeOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSubscriberResult deleteSubscriber(DeleteSubscriberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSubscriberNotificationResult deleteSubscriberNotification(DeleteSubscriberNotificationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterDataLakeDelegatedAdministratorResult deregisterDataLakeDelegatedAdministrator(DeregisterDataLakeDelegatedAdministratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataLakeExceptionSubscriptionResult getDataLakeExceptionSubscription(GetDataLakeExceptionSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataLakeOrganizationConfigurationResult getDataLakeOrganizationConfiguration(GetDataLakeOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataLakeSourcesResult getDataLakeSources(GetDataLakeSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubscriberResult getSubscriber(GetSubscriberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataLakeExceptionsResult listDataLakeExceptions(ListDataLakeExceptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataLakesResult listDataLakes(ListDataLakesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLogSourcesResult listLogSources(ListLogSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscribersResult listSubscribers(ListSubscribersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterDataLakeDelegatedAdministratorResult registerDataLakeDelegatedAdministrator(RegisterDataLakeDelegatedAdministratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataLakeResult updateDataLake(UpdateDataLakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataLakeExceptionSubscriptionResult updateDataLakeExceptionSubscription(UpdateDataLakeExceptionSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriberResult updateSubscriber(UpdateSubscriberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriberNotificationResult updateSubscriberNotification(UpdateSubscriberNotificationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
