/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securitylake.model.LogSource;
import java.util.List;

@SdkInternalApi
public class LogSourceMarshaller {
    private static final MarshallingInfo<String> ACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("account").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<List> SOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sources").build();
    private static final LogSourceMarshaller instance = new LogSourceMarshaller();

    public static LogSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(LogSource logSource, ProtocolMarshaller protocolMarshaller) {
        if (logSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)logSource.getAccount(), ACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)logSource.getRegion(), REGION_BINDING);
            protocolMarshaller.marshall(logSource.getSources(), SOURCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

